/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.common.active;

import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class ChannelingCastAbility
extends ActiveDragonAbility {
    public int chargeTime = 0;
    public long lastManaSpentTime = 0L;
    public long timeSinceStartChannel = -1L;

    public abstract int getSkillChargeTime();

    public abstract int getContinuousManaCostTime();

    public abstract int getInitManaCost();

    @Override
    public void onKeyPressed(Player player, Runnable onFinish, long castStartTime, long clientTime) {
        this.chargeTime = (int)(clientTime - castStartTime);
        if (clientTime - castStartTime >= (long)this.getSkillChargeTime() && castStartTime != -1L) {
            this.timeSinceStartChannel = clientTime - castStartTime - (long)this.getSkillChargeTime();
            this.onChanneling(player, (int)this.timeSinceStartChannel);
            if (this.chargeTime < this.getSkillChargeTime()) {
                this.chargeTime = this.getSkillChargeTime();
            }
            if (clientTime - this.lastManaSpentTime >= (long)this.getContinuousManaCostTime()) {
                this.lastManaSpentTime = clientTime;
                ManaHandler.consumeMana(player, this.getManaCost());
            }
        } else {
            this.onCharging(player, this.chargeTime);
            if (clientTime - castStartTime >= (long)(this.getSkillChargeTime() / 2) && castStartTime != -1L && clientTime - this.lastManaSpentTime >= (long)(this.getSkillChargeTime() / 2)) {
                ManaHandler.consumeMana(player, this.getInitManaCost());
                this.lastManaSpentTime = clientTime;
            }
        }
    }

    @Override
    public boolean canConsumeMana(Player player) {
        int manaCost = this.chargeTime < this.getSkillChargeTime() / 2 ? this.getManaCost() + this.getInitManaCost() : this.getManaCost();
        return ManaHandler.canConsumeMana(player, manaCost);
    }

    @Override
    public void onKeyReleased(Player player) {
        if (this.chargeTime >= this.getSkillChargeTime()) {
            this.castComplete(player);
            this.startCooldown();
        }
        this.chargeTime = 0;
    }

    public abstract void onCharging(Player var1, int var2);

    public abstract void onChanneling(Player var1, int var2);

    public abstract void castComplete(Player var1);

    @Override
    public CompoundTag saveNBT() {
        CompoundTag tag = super.saveNBT();
        tag.m_128405_("chargeTime", this.chargeTime);
        return tag;
    }

    @Override
    public void loadNBT(CompoundTag nbt) {
        super.loadNBT(nbt);
        this.chargeTime = nbt.m_128451_("chargeTime");
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        if (this.getSkillChargeTime() > 0) {
            components.add((Component)Component.m_237110_((String)"ds.skill.cast_time", (Object[])new Object[]{Functions.ticksToSeconds(this.getSkillChargeTime())}));
        }
        return components;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }
}

