/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.common.active;

import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ManaHandler;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public abstract class ChargeCastAbility
extends ActiveDragonAbility {
    public int castTime = 0;
    public boolean castFinished = false;

    public abstract int getSkillCastingTime();

    @Override
    public void onKeyPressed(Player player, Runnable onFinish, long castStartTime, long clientTime) {
        if (this.castFinished) {
            return;
        }
        this.castTime = (int)(clientTime - castStartTime);
        if (this.castTime >= this.getSkillCastingTime() && castStartTime != -1L && !this.castFinished) {
            this.castingComplete(player);
            this.startCooldown();
            castStartTime = clientTime;
            this.castFinished = true;
            ManaHandler.consumeMana(player, this.getManaCost());
            onFinish.run();
        } else {
            this.saveNBT();
            this.onCasting(player, this.castTime);
        }
    }

    @Override
    public void onKeyReleased(Player player) {
        this.castFinished = false;
        this.castTime = 0;
    }

    public abstract void onCasting(Player var1, int var2);

    public abstract void castingComplete(Player var1);

    @Override
    public CompoundTag saveNBT() {
        CompoundTag tag = super.saveNBT();
        tag.m_128405_("castTime", this.castTime);
        return tag;
    }

    @Override
    public void loadNBT(CompoundTag nbt) {
        super.loadNBT(nbt);
        this.castTime = nbt.m_128451_("castTime");
    }

    @Override
    public ArrayList<Component> getInfo() {
        ArrayList<Component> components = super.getInfo();
        if (this.getSkillCastingTime() > 0) {
            components.add((Component)Component.m_237110_((String)"ds.skill.cast_time", (Object[])new Object[]{Functions.ticksToSeconds(this.getSkillCastingTime())}));
        }
        return components;
    }

    public int getCastTime() {
        return this.castTime;
    }
}

