/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.magic.common.innate;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.common.innate.InnateDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public abstract class DragonClawsAbility
extends InnateDragonAbility {
    @Override
    public int getMaxLevel() {
        return 1;
    }

    @Override
    public int getMinLevel() {
        return 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ArrayList<Component> getInfo() {
        double damageBonus;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
        ArrayList<Component> components = super.getInfo();
        components.add((Component)Component.m_237115_((String)("ds.skill.tool_type." + this.getName())));
        Pair<Tiers, Integer> harvestInfo = this.getHarvestInfo();
        if (harvestInfo != null) {
            components.add((Component)Component.m_237110_((String)"ds.skill.harvest_level", (Object[])new Object[]{I18n.m_118938_((String)("ds.skill.harvest_level." + ((Tiers)harvestInfo.getFirst()).name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0])}));
        }
        double d = handler.isDragon() ? (handler.getLevel() == DragonLevel.ADULT ? ServerConfig.adultBonusDamage : (handler.getLevel() == DragonLevel.YOUNG ? ServerConfig.youngBonusDamage : ServerConfig.babyBonusDamage)) : (damageBonus = 0.0);
        if (damageBonus > 0.0) {
            components.add((Component)Component.m_237110_((String)"ds.skill.claws.damage", (Object[])new Object[]{"+" + damageBonus}));
        }
        return components;
    }

    @Override
    public int getLevel() {
        Pair<Tiers, Integer> harvestInfo = this.getHarvestInfo();
        int textureId = harvestInfo != null ? (Integer)harvestInfo.getSecond() : 0;
        return FMLEnvironment.dist == Dist.CLIENT ? textureId : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Pair<Tiers, Integer> getHarvestInfo() {
        TieredItem tieredItem;
        Tier tier;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_);
        if (handler.getType() == null) {
            return null;
        }
        Item item = handler.getInnateFakeTool().m_41720_();
        if (!(item instanceof TieredItem) || !((tier = (tieredItem = (TieredItem)item).m_43314_()) instanceof Tiers)) {
            return Pair.of((Object)Tiers.WOOD, (Object)0);
        }
        Tiers tier2 = (Tiers)tier;
        int textureId = 0;
        if (Tiers.WOOD.equals((Object)tier2)) {
            textureId = 1;
        } else if (Tiers.STONE.equals((Object)tier2)) {
            textureId = 2;
        } else if (Tiers.IRON.equals((Object)tier2)) {
            textureId = 3;
        } else if (Tiers.GOLD.equals((Object)tier2)) {
            textureId = 4;
        } else if (Tiers.DIAMOND.equals((Object)tier2)) {
            textureId = 5;
        } else if (Tiers.NETHERITE.equals((Object)tier2)) {
            textureId = 6;
        }
        return Pair.of((Object)tier2, (Object)textureId);
    }
}

