/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.objects.DragonMovementData;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class MixinEntity
extends CapabilityProvider<Entity> {
    protected MixinEntity(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Inject(at={@At(value="HEAD")}, method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, cancellable=true)
    private void positionRider(Entity entity, Entity.MoveFunction move, CallbackInfo callbackInfo) {
        MixinEntity mixinEntity;
        MixinEntity self = this;
        if (DragonUtils.isDragon((Entity)self) && this.m_20363_(entity) && (mixinEntity = this) instanceof Player) {
            Player player = (Player)mixinEntity;
            if (entity instanceof Player) {
                Player passenger = (Player)entity;
                DragonMovementData md = DragonUtils.getHandler((Entity)self).getMovementData();
                double heightOffset = -0.2 * this.m_6048_();
                Vec3 offsetFromBb = new Vec3(0.0, heightOffset, -1.5 * (double)player.m_20205_());
                Vec3 offsetFromCenter = new Vec3(0.0, this.m_6048_() - heightOffset, 0.0);
                offsetFromCenter = offsetFromCenter.m_82496_((float)Math.toRadians((double)md.prevXRot * 1.5)).m_82535_(-((float)Math.toRadians(md.prevZRot * 90.0f)));
                offsetFromCenter = offsetFromCenter.m_82542_(1.0, Math.signum(offsetFromCenter.f_82480_), 1.0);
                Vec3 totalOffset = offsetFromCenter.m_82549_(offsetFromBb).m_82524_(-((float)Math.toRadians(md.bodyYawLastFrame)));
                Vec3 passPos = player.m_20182_().m_82549_(totalOffset);
                move.m_20372_((Entity)passenger, passPos.m_7096_(), passPos.m_7098_(), passPos.m_7094_());
                ((Entity)this).m_7340_((Entity)passenger);
                callbackInfo.cancel();
            }
        }
    }

    @Inject(method={"onPassengerTurned(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void onPassengerTurned(Entity passenger, CallbackInfo callbackInfo) {
        Player player;
        if (passenger instanceof Player && (player = (Player)passenger).m_20202_() != null && DragonUtils.getHandler(player.m_20202_()).isDragon() && player.m_9236_().m_5776_()) {
            this.clampRotation(passenger);
        }
    }

    @Unique
    private void clampRotation(Entity passenger) {
        Entity self = (Entity)this;
        DragonStateHandler selfHandler = DragonUtils.getHandler(self);
        DragonMovementData selfmd = selfHandler.getMovementData();
        if (DragonUtils.isDragon(passenger)) {
            DragonStateHandler handler = DragonUtils.getHandler(passenger);
            DragonMovementData md = handler.getMovementData();
            float facing = (float)Mth.m_14175_((double)((double)passenger.m_146908_() - selfmd.bodyYawLastFrame));
            float facingClamped = Mth.m_14036_((float)facing, (float)-150.0f, (float)150.0f);
            passenger.f_19859_ += facingClamped - facing + self.f_19859_;
            md.bodyYaw = selfmd.bodyYawLastFrame;
            md.headYaw = -facing;
            passenger.m_146922_((float)((double)(passenger.m_146908_() + facingClamped - facing) + (ClientDragonRender.rotateCameraWithDragon != false ? selfmd.bodyYawLastFrame - selfmd.bodyYaw : 0.0)));
            if (passenger instanceof DragonEntity) {
                DragonEntity de = (DragonEntity)passenger;
                de.prevZRot = ((DragonEntity)self).prevZRot;
            }
        } else {
            float facing = (float)Mth.m_14175_((double)((double)passenger.m_146908_() - selfmd.bodyYawLastFrame));
            float facingClamped = Mth.m_14036_((float)facing, (float)-120.0f, (float)120.0f);
            passenger.f_19859_ += facingClamped - facing + self.f_19859_;
            passenger.m_5618_((float)((double)(passenger.m_146908_() + facingClamped - facing) + (ClientDragonRender.rotateCameraWithDragon != false ? selfmd.bodyYawLastFrame - selfmd.bodyYaw : 0.0)));
            passenger.m_146922_((float)((double)(passenger.m_146908_() + facingClamped - facing) + (ClientDragonRender.rotateCameraWithDragon != false ? selfmd.bodyYawLastFrame - selfmd.bodyYaw : 0.0)));
            passenger.m_5616_(passenger.m_146908_());
        }
    }

    @Shadow
    public boolean m_20363_(Entity p_184196_1_) {
        throw new IllegalStateException("Mixin failed to shadow hasPassenger()");
    }

    @Shadow
    public double m_6048_() {
        throw new IllegalStateException("Mixin failed to shadow getPassengersRidingOffset()");
    }

    @Shadow
    public double m_20185_() {
        throw new IllegalStateException("Mixin failed to shadow getX()");
    }

    @Shadow
    public double m_20186_() {
        throw new IllegalStateException("Mixin failed to shadow getY()");
    }

    @Shadow
    public double m_20189_() {
        throw new IllegalStateException("Mixin failed to shadow getZ()");
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/Entity;displayFireAnimation()Z"}, cancellable=true)
    private void hideCaveDragonFireAnimation(CallbackInfoReturnable<Boolean> ci) {
        DragonStateProvider.getCap((Entity)this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && Objects.equals(dragonStateHandler.getType(), DragonTypes.CAVE)) {
                ci.setReturnValue((Object)false);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/Entity;getPassengersRidingOffset()D"}, cancellable=true)
    public void getDragonPassengersRidingOffset(CallbackInfoReturnable<Double> ci) {
        if (DragonUtils.isDragon((Entity)this)) {
            if (!DragonUtils.isDragon((Entity)((Entity)this).m_20197_().get(0))) {
                double height = DragonSizeHandler.getDragonHeight((Player)this);
                switch (((Entity)this).m_20089_()) {
                    case FALL_FLYING: 
                    case SWIMMING: 
                    case SPIN_ATTACK: {
                        ci.setReturnValue((Object)(height * 0.6));
                        break;
                    }
                    case CROUCHING: {
                        ci.setReturnValue((Object)(height * 0.45));
                        break;
                    }
                    default: {
                        ci.setReturnValue((Object)(height * 0.5));
                        break;
                    }
                }
            } else {
                double height = DragonSizeHandler.getDragonHeight((Player)this);
                switch (((Entity)this).m_20089_()) {
                    case FALL_FLYING: 
                    case SWIMMING: 
                    case SPIN_ATTACK: {
                        ci.setReturnValue((Object)(height * 0.66));
                        break;
                    }
                    case CROUCHING: {
                        ci.setReturnValue((Object)(height * 0.61));
                        break;
                    }
                    default: {
                        ci.setReturnValue((Object)(height * 0.66));
                    }
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/Entity;isVisuallyCrawling()Z"}, cancellable=true)
    public void isDragonVisuallyCrawling(CallbackInfoReturnable<Boolean> ci) {
        if (DragonUtils.isDragon((Entity)this)) {
            ci.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"canEnterPose(Lnet/minecraft/world/entity/Pose;)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;getBoundingBoxForPose(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/phys/AABB;"))
    public AABB dragonPoseBB(Entity entity, Pose pose) {
        if (DragonUtils.isDragon(entity) && ServerConfig.sizeChangesHitbox.booleanValue()) {
            boolean squish = DragonUtils.getDragonBody(entity) != null ? DragonUtils.getDragonBody(entity).isSquish() : false;
            double heightMult = 1.0;
            if (DragonUtils.getDragonBody(entity) != null) {
                squish = DragonUtils.getDragonBody(entity).isSquish();
                heightMult = DragonUtils.getDragonBody(entity).getHeightMult();
            }
            double size = DragonUtils.getHandler(entity).getSize();
            double height = DragonSizeHandler.calculateModifiedHeight(DragonSizeHandler.calculateDragonHeight(size, ServerConfig.hitboxGrowsPastHuman), pose, ServerConfig.sizeChangesHitbox, squish) * heightMult;
            double width = DragonSizeHandler.calculateDragonWidth(size, ServerConfig.hitboxGrowsPastHuman) / 2.0;
            return DragonSizeHandler.calculateDimensions(width, height).m_20393_(entity.m_20182_());
        }
        return this.m_20217_(pose);
    }

    @Shadow
    protected AABB m_20217_(Pose pose) {
        throw new IllegalStateException("Mixin failed to shadow getBoundingBoxForPose()");
    }
}

