/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={InventoryScreen.class})
public abstract class MixinInventoryScreen
extends EffectRenderingInventoryScreen<InventoryMenu>
implements RecipeUpdateListener {
    @Unique
    private static float dragon_survival$storedXAngle = 0.0f;
    @Unique
    private static float dragon_survival$storedYAngle = 0.0f;

    public MixinInventoryScreen(InventoryMenu p_98701_, Inventory p_98702_, Component p_98703_) {
        super((AbstractContainerMenu)p_98701_, p_98702_, p_98703_);
    }

    @Redirect(method={"renderEntityInInventory"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;runAsFancy(Ljava/lang/Runnable;)V"))
    private static void dragonScreenEntityRender(Runnable runnable, @Local(argsOnly=true) LivingEntity entity) {
        LivingEntity newEntity;
        if (entity instanceof DragonEntity) {
            DragonEntity de = (DragonEntity)entity;
            newEntity = de.getPlayer();
        } else {
            newEntity = entity;
        }
        if (DragonStateProvider.getCap((Entity)newEntity).isPresent() && DragonUtils.getHandler((Entity)newEntity).isDragon()) {
            DragonStateProvider.getCap((Entity)newEntity).ifPresent(handler -> {
                if (handler.isDragon()) {
                    double bodyYaw = handler.getMovementData().bodyYaw;
                    double headYaw = handler.getMovementData().headYaw;
                    double headPitch = handler.getMovementData().headPitch;
                    Vec3 deltaMovement = handler.getMovementData().deltaMovement;
                    Vec3 deltaMovementLastFrame = handler.getMovementData().deltaMovementLastFrame;
                    handler.getMovementData().bodyYaw = newEntity.f_20883_;
                    handler.getMovementData().headYaw = -Math.toDegrees(dragon_survival$storedXAngle);
                    handler.getMovementData().headPitch = -Math.toDegrees(dragon_survival$storedYAngle);
                    handler.getMovementData().deltaMovement = Vec3.f_82478_;
                    handler.getMovementData().deltaMovementLastFrame = Vec3.f_82478_;
                    ClientDragonRender.isOverridingMovementData = true;
                    RenderSystem.runAsFancy((Runnable)runnable);
                    ClientDragonRender.isOverridingMovementData = false;
                    dragon_survival$storedXAngle = 0.0f;
                    dragon_survival$storedYAngle = 0.0f;
                    handler.getMovementData().bodyYaw = bodyYaw;
                    handler.getMovementData().headYaw = headYaw;
                    handler.getMovementData().headPitch = headPitch;
                    handler.getMovementData().deltaMovement = deltaMovement;
                    handler.getMovementData().deltaMovementLastFrame = deltaMovementLastFrame;
                } else {
                    RenderSystem.runAsFancy((Runnable)runnable);
                }
            });
        } else {
            RenderSystem.runAsFancy((Runnable)runnable);
        }
    }

    @ModifyArg(method={"renderEntityInInventory"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPoseMatrix(Lorg/joml/Matrix4f;)V"), index=0)
    private static Matrix4f dragonScreenEntityRescaler(Matrix4f pMatrix) {
        double size;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (handler.isDragon() && (size = handler.getSize()) > ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
            float scale = (float)(ServerConfig.DEFAULT_MAX_GROWTH_SIZE / size);
            pMatrix.scale(scale, scale, scale);
        }
        return pMatrix;
    }

    @ModifyArg(method={"renderEntityInInventoryFollowsMouse"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventoryFollowsAngle(Lnet/minecraft/client/gui/GuiGraphics;IIIFFLnet/minecraft/world/entity/LivingEntity;)V"), index=4)
    private static float dragon_survival$cancelXEntityAnglingForDragons(float angleXComponent, @Local(argsOnly=true) LivingEntity entity) {
        DragonStateHandler handler = DragonStateProvider.getHandler((Entity)entity);
        if (handler != null && handler.isDragon()) {
            dragon_survival$storedXAngle = angleXComponent;
            return 0.0f;
        }
        return angleXComponent;
    }

    @ModifyArg(method={"renderEntityInInventoryFollowsMouse"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/InventoryScreen;renderEntityInInventoryFollowsAngle(Lnet/minecraft/client/gui/GuiGraphics;IIIFFLnet/minecraft/world/entity/LivingEntity;)V"), index=5)
    private static float dragon_survival$cancelYEntityAnglingForDragons(float angleYComponent, @Local(argsOnly=true) LivingEntity entity) {
        DragonStateHandler handler = DragonStateProvider.getHandler((Entity)entity);
        if (handler != null && handler.isDragon()) {
            dragon_survival$storedYAngle = angleYComponent;
            return 0.0f;
        }
        return angleYComponent;
    }
}

