/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.mixins;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.util.BlockPosHelper;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayerEntity
extends LivingEntity {
    @Unique
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    @Unique
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);

    protected MixinPlayerEntity(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void isInvulnerableTo(DamageSource pSource, CallbackInfoReturnable<Boolean> cir) {
        if (pSource == this.m_269291_().m_269318_() && DragonUtils.isDragon((Entity)this) && ServerConfig.disableSuffocation.booleanValue()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"isImmobile"}, at={@At(value="HEAD")}, cancellable=true)
    private void castMovement(CallbackInfoReturnable<Boolean> ci) {
        DragonStateHandler cap = DragonUtils.getHandler((Entity)this);
        if (!this.m_21224_() && !this.m_5803_()) {
            if (cap.getMagicData().getCurrentlyCasting() != null && cap.getMagicData().getCurrentlyCasting().requiresStationaryCasting() && !ServerConfig.canMoveWhileCasting.booleanValue()) {
                ci.setReturnValue((Object)true);
            }
            if (Arrays.stream(cap.getEmoteData().currentEmotes).noneMatch(Objects::nonNull) && !ServerConfig.canMoveInEmote.booleanValue()) {
                ci.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isSleepingLongEnough"}, at={@At(value="HEAD")}, cancellable=true)
    public void isSleepingLongEnough(CallbackInfoReturnable<Boolean> ci) {
        if (DragonUtils.isDragon((Entity)this)) {
            DragonStateProvider.getCap((Entity)this).ifPresent(cap -> {
                if (cap.treasureResting && cap.treasureSleepTimer >= 100) {
                    ci.setReturnValue((Object)true);
                }
            });
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"eat"}, cancellable=true)
    public void dragonEat(Level level, ItemStack stack, CallbackInfoReturnable<ItemStack> callback) {
        if (DragonFoodHandler.disableDragonFoodHandling) {
            return;
        }
        Player player = (Player)this;
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            FoodProperties properties;
            if (handler.isDragon() && (properties = DragonFoodHandler.getFoodProperties(stack, handler.getType(), (LivingEntity)player)) != null) {
                this.m_36324_().m_38707_(properties.m_38744_(), properties.m_38745_());
                this.m_36246_((Stat<Item>)Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, this.f_19796_.m_188501_() * 0.1f + 0.9f);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10592_.m_23682_(serverPlayer, stack);
                }
                callback.setReturnValue((Object)super.m_5584_(level, stack));
            }
        });
    }

    @Shadow
    public FoodData m_36324_() {
        throw new IllegalStateException("Mixin failed to shadow getFoodData()");
    }

    @Shadow
    public void m_36246_(Stat<Item> stat) {
        throw new IllegalStateException("Mixin failed to shadow awardStat()");
    }

    @Inject(at={@At(value="HEAD")}, method={"Lnet/minecraft/world/entity/player/Player;getMyRidingOffset()D"}, cancellable=true)
    public void dragonRidingOffset(CallbackInfoReturnable<Double> ci) {
        DragonStateProvider.getCap((Entity)this).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                ci.setReturnValue((Object)0.25);
            }
        });
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")})
    public void travel(Vec3 pTravelVector, CallbackInfo ci) {
        if (DragonUtils.isDragon((Entity)this)) {
            double d01 = this.m_20185_();
            double d11 = this.m_20186_();
            double d21 = this.m_20189_();
            if (DragonStateProvider.getCap((Entity)this).isPresent() && ServerConfig.bonuses.booleanValue() && ServerConfig.caveLavaSwimming.booleanValue() && DragonUtils.isDragonType((Entity)this, (AbstractDragonType)DragonTypes.CAVE) && DragonSizeHandler.getOverridePose(this) == Pose.SWIMMING || this.m_6069_() && !this.m_20159_()) {
                double d4;
                double d3 = this.m_20154_().f_82480_;
                double d = d4 = d3 < -0.2 ? 0.185 : 0.06;
                if (d3 <= 0.0 || this.f_20899_ || !this.m_9236_().m_8055_(BlockPosHelper.get(this.m_20185_(), this.m_20186_() + 1.0 - 0.1, this.m_20189_())).m_60819_().m_76178_()) {
                    Vec3 vector3d1 = this.m_20184_();
                    this.m_20256_(vector3d1.m_82520_(0.0, (d3 - vector3d1.f_82480_) * d4, 0.0));
                }
                if (this.m_21515_() || this.m_6109_()) {
                    boolean flag;
                    double d0 = 0.08;
                    AttributeInstance gravity = this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                    boolean bl = flag = this.m_20184_().f_82480_ <= 0.0;
                    if (flag && this.m_21023_(MobEffects.f_19591_)) {
                        if (gravity != null && !gravity.m_22109_(SLOW_FALLING)) {
                            gravity.m_22118_(SLOW_FALLING);
                        }
                        this.f_19789_ = 0.0f;
                    } else if (gravity != null && gravity.m_22109_(SLOW_FALLING)) {
                        gravity.m_22130_(SLOW_FALLING);
                    }
                    if (gravity != null) {
                        d0 = gravity.m_22135_();
                    }
                    FluidState fluidstate = this.m_9236_().m_6425_(this.m_20183_());
                    if (this.m_20077_() && this.m_6129_() && !this.m_203441_(fluidstate) && ServerConfig.bonuses.booleanValue() && ServerConfig.caveLavaSwimming.booleanValue() && DragonUtils.isDragonType((Entity)this, (AbstractDragonType)DragonTypes.CAVE)) {
                        double d8 = this.m_20186_();
                        float f5 = this.m_20142_() ? 0.9f : this.m_6108_();
                        float f6 = 0.05f;
                        float f7 = Math.min(3.0f, (float)EnchantmentHelper.m_44922_((LivingEntity)this));
                        if (!this.m_20096_()) {
                            f7 *= 0.5f;
                        }
                        if (f7 > 0.0f) {
                            f5 += (0.54600006f - f5) * f7 / 2.5f;
                            f6 += (this.m_6113_() - f6) * f7 / 2.5f;
                        }
                        if (this.m_21023_(MobEffects.f_19593_)) {
                            f5 = 0.96f;
                        }
                        this.m_19920_(f6 *= (float)this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22135_(), pTravelVector);
                        this.m_6478_(MoverType.SELF, this.m_20184_());
                        Vec3 vector3d6 = this.m_20184_();
                        if (this.f_19862_ && this.m_6147_()) {
                            vector3d6 = new Vec3(vector3d6.f_82479_, 0.2, vector3d6.f_82481_);
                        }
                        this.m_20256_(vector3d6.m_82542_((double)f5, (double)0.8f, (double)f5));
                        Vec3 vector3d2 = this.m_20994_(d0, flag, this.m_20184_());
                        this.m_20256_(vector3d2);
                        if (this.f_19862_ && this.m_20229_(vector3d2.f_82479_, vector3d2.f_82480_ + (double)0.6f - this.m_20186_() + d8, vector3d2.f_82481_)) {
                            this.m_20334_(vector3d2.f_82479_, 0.3f, vector3d2.f_82481_);
                        }
                    }
                }
                this.m_267651_(this instanceof FlyingAnimal);
                this.m_36378_(this.m_20185_() - d01, this.m_20186_() - d11, this.m_20189_() - d21);
            }
        }
    }

    @Shadow
    public void m_36378_(double d, double e, double f) {
        throw new IllegalStateException("Mixin failed to shadow checkMovementStatistics()");
    }
}

