/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network;

import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public abstract class ISidedMessage<T extends ISidedMessage<T>>
implements IMessage<T> {
    public int playerId;

    public ISidedMessage(int playerId) {
        this.playerId = playerId;
    }

    @Override
    public void handle(T message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ClientProxy.handleRunClient(message, context);
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            this.runServer(message, context, sender);
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), this.create(message));
        }
        this.runCommon(message, context);
        context.setPacketHandled(true);
    }

    public abstract T create(T var1);

    public abstract void runClient(T var1, NetworkEvent.Context var2, Player var3);

    public abstract void runCommon(T var1, NetworkEvent.Context var2);

    public abstract void runServer(T var1, NetworkEvent.Context var2, ServerPlayer var3);
}

