/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.claw;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public record SyncBrokenTool(int playerId, int slot) {
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.playerId);
        buffer.writeInt(this.slot);
    }

    public static SyncBrokenTool decode(FriendlyByteBuf buffer) {
        return new SyncBrokenTool(buffer.readInt(), buffer.readInt());
    }

    public static void handle(SyncBrokenTool message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> {
                Entity entity;
                Player localPlayer = ClientProxy.getLocalPlayer();
                if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
                    DragonStateHandler handler = DragonUtils.getHandler(entity);
                    if (handler.switchedTool || handler.switchedWeapon) {
                        localPlayer.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        handler.getClawToolData().getClawsInventory().m_6836_(message.slot, ItemStack.f_41583_);
                    }
                }
            });
        }
        context.setPacketHandled(true);
    }
}

