/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.claw;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncDragonClawRender
implements IMessage<SyncDragonClawRender> {
    public int playerId;
    public boolean state;

    public SyncDragonClawRender() {
    }

    public SyncDragonClawRender(int playerId, boolean state) {
        this.playerId = playerId;
        this.state = state;
    }

    @Override
    public void encode(SyncDragonClawRender message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.state);
    }

    @Override
    public SyncDragonClawRender decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        boolean state = buffer.readBoolean();
        return new SyncDragonClawRender(playerId, state);
    }

    @Override
    public void handle(SyncDragonClawRender message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncDragonClawRender(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                handler.getClawToolData().shouldRenderClaws = message.state;
            });
            if (ServerConfig.syncClawRender.booleanValue()) {
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncDragonClawRender(sender.m_19879_(), message.state));
            }
        }
        supplier.get().setPacketHandled(true);
    }
}

