/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.client;

import by.dragonsurvivalteam.dragonsurvival.client.gui.dragon_editor.DragonEditorScreen;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientEvents;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.ClientFlightHandler;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.DragonAltarHandler;
import by.dragonsurvivalteam.dragonsurvival.client.handlers.magic.ClientCastingHandler;
import by.dragonsurvivalteam.dragonsurvival.client.render.ClientDragonRender;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.WingObtainmentController;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.network.ISidedMessage;
import by.dragonsurvivalteam.dragonsurvival.network.RequestClientData;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawRender;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawsMenu;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncDragonSkinSettings;
import by.dragonsurvivalteam.dragonsurvival.network.dragon_editor.SyncPlayerSkinPreset;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncDeltaMovement;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlightSpeed;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlyingStatus;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncAbilityCasting;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicCap;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncMagicStats;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncPotionAddedEffect;
import by.dragonsurvivalteam.dragonsurvival.network.magic.SyncPotionRemovedEffect;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncChatEvent;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonMovement;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncDragonTypeData;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncGrowthState;
import by.dragonsurvivalteam.dragonsurvival.network.player.SyncSize;
import by.dragonsurvivalteam.dragonsurvival.network.player.SynchronizeDragonCap;
import by.dragonsurvivalteam.dragonsurvival.network.status.DiggingStatus;
import by.dragonsurvivalteam.dragonsurvival.network.status.PlayerJumpSync;
import by.dragonsurvivalteam.dragonsurvival.network.status.RefreshDragons;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncAltarCooldown;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncMagicSourceStatus;
import by.dragonsurvivalteam.dragonsurvival.network.status.SyncTreasureRestStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;

public class ClientProxy {
    @Nullable
    public static Player getLocalPlayer() {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.m_91087_().f_91074_;
        }
        return null;
    }

    public static void handleSyncDragonClawRender(SyncDragonClawRender message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            DragonStateProvider.getCap(entity).ifPresent(handler -> {
                handler.getClawToolData().shouldRenderClaws = message.state;
            });
        }
    }

    public static void handleSyncDragonClawsMenu(SyncDragonClawsMenu message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            DragonStateProvider.getCap(entity).ifPresent(handler -> {
                handler.getClawToolData().setMenuOpen(message.state);
                handler.getClawToolData().setClawsInventory(message.clawInventory);
            });
        }
    }

    public static void handleSyncDragonSkinSettings(SyncDragonSkinSettings message) {
        Level world;
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = (world = localPlayer.m_9236_()).m_6815_(message.playerId)) instanceof Player) {
            DragonStateProvider.getCap(entity).ifPresent(dragonStateHandler -> {
                dragonStateHandler.getSkinData().renderNewborn = message.newborn;
                dragonStateHandler.getSkinData().renderYoung = message.young;
                dragonStateHandler.getSkinData().renderAdult = message.adult;
            });
        }
    }

    public static void requestClientData(DragonStateHandler handler) {
        if (handler == DragonUtils.getHandler((Entity)Minecraft.m_91087_().f_91074_)) {
            ClientEvents.sendClientData(new RequestClientData(handler.getType(), handler.getBody(), handler.getLevel()));
        }
    }

    public static void handleRequestClientData(RequestClientData message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            ClientEvents.sendClientData(message);
        }
    }

    public static <T extends ISidedMessage<T>> void handleRunClient(T message, NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Entity entity;
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
                Player player = (Player)entity;
                message.runClient(message, context, player);
            }
        });
    }

    public static void handleSyncPlayerSkinPreset(SyncPlayerSkinPreset message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                handler.getSkinData().skinPreset = message.preset;
                handler.getSkinData().compileSkin();
            });
        }
    }

    public static void handleSyncDeltaMovement(SyncDeltaMovement message) {
        Player player;
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player && (player = (Player)entity) != localPlayer) {
            player.m_20334_(message.speedX, message.speedY, message.speedZ);
        }
    }

    public static void handleSyncFlightSpeed(SyncFlightSpeed message) {
        Player player;
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player && (player = (Player)entity) != localPlayer) {
            player.m_20256_(message.flightSpeed);
        }
    }

    public static void handleOpenDragonAltar() {
        DragonAltarHandler.openAltar();
    }

    public static void handleOpenDragonEditorPacket() {
        Minecraft.m_91087_().m_91152_((Screen)new DragonEditorScreen(Minecraft.m_91087_().f_91080_));
    }

    public static void handleSyncFlyingStatus(SyncFlyingStatus message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> handler.setWingsSpread(message.state));
        }
    }

    public static void handleSyncSpinStatus(SyncSpinStatus message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
                dragonStateHandler.getMovementData().spinAttack = message.spinAttack;
                dragonStateHandler.getMovementData().spinCooldown = message.spinCooldown;
                dragonStateHandler.getMovementData().spinLearned = message.spinLearned;
            });
            ClientFlightHandler.lastSync = player.f_19797_;
        }
    }

    public static void handleSyncAbilityCasting(SyncAbilityCasting message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(arg_0 -> ClientProxy.lambda$handleSyncAbilityCasting$8(message, player, (Player)localPlayer, arg_0));
        }
    }

    public static void handleSyncMagicCap(SyncMagicCap message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> handler.getMagicData().readNBT(message.nbt));
        }
    }

    public static void handleSyncMagicstats(SyncMagicStats message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerid)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                handler.getMagicData().setCurrentMana(message.currentMana);
                handler.getMagicData().setSelectedAbilitySlot(message.selectedSlot);
                handler.getMagicData().setRenderAbilities(message.renderHotbar);
            });
        }
    }

    public static void handleSyncPotionAddedEffect(SyncPotionAddedEffect message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            Entity entity = localPlayer.m_9236_().m_6815_(message.entityId);
            MobEffect mobEffect = MobEffect.m_19453_((int)message.effectId);
            if (mobEffect != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_7292_(new MobEffectInstance(mobEffect, message.duration, message.amplifier));
            }
        }
    }

    public static void handleSyncPotionRemovedEffect(SyncPotionRemovedEffect message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            Entity entity = localPlayer.m_9236_().m_6815_(message.playerId);
            MobEffect mobEffect = MobEffect.m_19453_((int)message.effectId);
            if (mobEffect != null && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.m_21195_(mobEffect);
            }
        }
    }

    public static void handlePacketSyncCapabilityMovement(SyncDragonMovement message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                handler.setBite(message.bite);
                handler.setFirstPerson(message.isFirstPerson);
                handler.setFreeLook(message.isFreeLook);
                handler.setDesiredMoveVec(new Vec2(message.desiredMoveVecX, message.desiredMoveVecY));
            });
        }
    }

    public static void handleSyncChatEvent(SyncChatEvent message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            WingObtainmentController.clientMessageRecieved(message);
        }
    }

    public static void handleSyncDragonTypeData(SyncDragonTypeData message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                if (handler.getType() != null) {
                    handler.getType().readNBT(message.nbt);
                }
            });
        }
    }

    public static void handleSyncGrowthState(SyncGrowthState message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            DragonStateProvider.getCap((Entity)localPlayer).ifPresent(handler -> {
                handler.growing = message.growing;
            });
        }
    }

    public static void handleSynchronizeDragonCap(SynchronizeDragonCap message) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null) {
            Entity entity;
            if (ClientDragonRender.dragonArmor != null) {
                ClientDragonRender.dragonArmor.playerId = localPlayer.m_19879_();
            }
            if ((entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
                Player player = (Player)entity;
                DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                    handler.setType(message.dragonType, player);
                    handler.setBody(message.dragonBody, player);
                    handler.setIsHiding(message.hiding);
                    handler.setHasFlight(message.hasWings);
                    handler.setSize(message.size, player);
                    handler.setPassengerId(message.passengerId);
                });
                if (player != localPlayer) {
                    DragonEntity dragon = (DragonEntity)((EntityType)DSEntities.DRAGON.get()).m_20615_(localPlayer.m_9236_());
                    dragon.playerId = player.m_19879_();
                    ClientDragonRender.playerDragonHashMap.computeIfAbsent(player.m_19879_(), integer -> new AtomicReference<DragonEntity>(dragon)).getAndSet(dragon);
                }
            }
        }
    }

    public static void handleSyncSize(SyncSize message) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.playerId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> handler.setSize(message.size, player));
            player.m_6210_();
        }
    }

    public static void handleDiggingStatus(DiggingStatus message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                handler.getMovementData().dig = message.status;
            });
        }
    }

    public static void handlePlayerJumpSync(PlayerJumpSync message) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.playerId);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ClientEvents.dragonsJumpingTicks.put(player.m_19879_(), message.ticks);
        }
    }

    public static void handleRefreshDragons(RefreshDragons message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        ClientDragonRender.dragonArmor = (DragonEntity)((EntityType)DSEntities.DRAGON_ARMOR.get()).m_20615_(localPlayer.m_9236_());
        if (ClientDragonRender.dragonArmor != null) {
            ClientDragonRender.dragonArmor.playerId = localPlayer.m_19879_();
        }
        if ((entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonEntity dragon = (DragonEntity)((EntityType)DSEntities.DRAGON.get()).m_20615_(localPlayer.m_9236_());
            dragon.playerId = player.m_19879_();
            ClientDragonRender.playerDragonHashMap.computeIfAbsent(player.m_19879_(), integer -> new AtomicReference<DragonEntity>(dragon)).getAndSet(dragon);
        }
    }

    public static void handleSyncAltarCooldown(SyncAltarCooldown message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateHandler dragonStateHandler = DragonUtils.getHandler((Entity)player);
            dragonStateHandler.altarCooldown = message.cooldown;
        }
    }

    public static void handleSyncMagicSourceStatus(SyncMagicSourceStatus message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                handler.getMagicData().onMagicSource = message.state;
                handler.getMagicData().magicSourceTimer = message.timer;
            });
        }
    }

    public static void handleSyncTreasureRestStatus(SyncTreasureRestStatus message) {
        Entity entity;
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer != null && (entity = localPlayer.m_9236_().m_6815_(message.playerId)) instanceof Player) {
            Player player = (Player)entity;
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                if (message.state != handler.treasureResting) {
                    handler.treasureRestTimer = 0;
                    handler.treasureSleepTimer = 0;
                }
                handler.treasureResting = message.state;
            });
        }
    }

    private static /* synthetic */ void lambda$handleSyncAbilityCasting$8(SyncAbilityCasting message, Player player, Player localPlayer, DragonStateHandler handler) {
        ActiveDragonAbility ability = handler.getMagicData().getAbilityFromSlot(message.abilitySlot);
        ability.loadNBT(message.nbt);
        handler.getMagicData().isCasting = message.isCasting;
        if (message.isCasting) {
            ability.onKeyPressed(player, () -> {
                if (player.m_19879_() == localPlayer.m_19879_()) {
                    ClientCastingHandler.hasCast = true;
                    ClientCastingHandler.status = (byte)2;
                }
            }, message.castStartTime, message.clientTime);
        } else {
            ability.onKeyReleased(player);
        }
    }
}

