/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.config;

import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncBooleanConfig
implements IMessage<SyncBooleanConfig> {
    public String path;
    public boolean value;

    public SyncBooleanConfig() {
    }

    public SyncBooleanConfig(String path, boolean value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public void encode(SyncBooleanConfig message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.value);
        buffer.m_130070_(message.path);
    }

    @Override
    public SyncBooleanConfig decode(FriendlyByteBuf buffer) {
        boolean value = buffer.readBoolean();
        String path = buffer.m_130277_();
        return new SyncBooleanConfig(path, value);
    }

    @Override
    public void handle(SyncBooleanConfig message, Supplier<NetworkEvent.Context> supplier) {
        Object object;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            if (sender == null || !sender.m_20310_(2)) {
                context.setPacketHandled(true);
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncBooleanConfig(message.path, message.value));
        }
        if ((object = ConfigHandler.serverSpec.getValues().get(message.path)) instanceof ForgeConfigSpec.BooleanValue) {
            ForgeConfigSpec.BooleanValue booleanValue = (ForgeConfigSpec.BooleanValue)object;
            context.enqueueWork(() -> {
                ConfigHandler.updateConfigValue((ForgeConfigSpec.ConfigValue)booleanValue, (Object)message.value);
                if (message.path.equals("tooltips.hideUnsafeFood")) {
                    DragonFoodHandler.clearTooltipMaps();
                }
            });
        }
        context.setPacketHandled(true);
    }
}

