/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.config;

import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncEnumConfig
implements IMessage<SyncEnumConfig> {
    public String path;
    public Enum<?> value;

    public SyncEnumConfig() {
    }

    public SyncEnumConfig(String path, Enum<?> value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public void encode(SyncEnumConfig message, FriendlyByteBuf buffer) {
        buffer.m_130070_(message.value.getDeclaringClass().getName());
        buffer.m_130068_(message.value);
        buffer.m_130070_(message.path);
    }

    @Override
    public SyncEnumConfig decode(FriendlyByteBuf buffer) {
        String classType = buffer.m_130277_();
        Enum enumValue = null;
        try {
            Class<?> cls = Class.forName(classType);
            enumValue = buffer.m_130066_(cls);
        }
        catch (ClassNotFoundException cls) {
            // empty catch block
        }
        String path = buffer.m_130277_();
        return new SyncEnumConfig(path, enumValue);
    }

    @Override
    public void handle(SyncEnumConfig message, Supplier<NetworkEvent.Context> supplier) {
        Object object;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            if (sender == null || !sender.m_20310_(2)) {
                context.setPacketHandled(true);
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncEnumConfig(message.path, message.value));
        }
        if ((object = ConfigHandler.serverSpec.getValues().get(message.path)) instanceof ForgeConfigSpec.EnumValue) {
            ForgeConfigSpec.EnumValue enumValue = (ForgeConfigSpec.EnumValue)object;
            context.enqueueWork(() -> ConfigHandler.updateConfigValue((ForgeConfigSpec.ConfigValue)enumValue, message.value));
        }
        context.setPacketHandled(true);
    }
}

