/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.config;

import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonFoodHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncListConfig
implements IMessage<SyncListConfig> {
    public String path;
    public List<?> value;

    public SyncListConfig() {
    }

    public SyncListConfig(String path, List<?> value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public void encode(SyncListConfig message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.value.size());
        for (Object object : message.value) {
            if (object instanceof Number) {
                Number number = (Number)object;
                buffer.m_130070_(number.toString());
                continue;
            }
            buffer.m_130070_(object.toString());
        }
        buffer.m_130070_(message.path);
    }

    @Override
    public SyncListConfig decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            list.add(buffer.m_130277_());
        }
        String path = buffer.m_130277_();
        return new SyncListConfig(path, list);
    }

    @Override
    public void handle(SyncListConfig message, Supplier<NetworkEvent.Context> supplier) {
        UnmodifiableConfig spec;
        Object config;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            if (sender == null || !sender.m_20310_(2)) {
                context.setPacketHandled(true);
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncListConfig(message.path, message.value));
        }
        if ((config = (spec = ConfigHandler.serverSpec.getValues()).get(message.path)) instanceof ForgeConfigSpec.ConfigValue) {
            ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)config;
            context.enqueueWork(() -> {
                ConfigHandler.updateConfigValue(configValue, message.value);
                if (message.path.startsWith("food")) {
                    DragonFoodHandler.rebuildFoodMap();
                } else if (message.path.contains("SpeedupBlocks")) {
                    DragonConfigHandler.rebuildSpeedupBlocksMap();
                } else if (message.path.contains("seaHydrationBlocks") || message.path.contains("seaHydrationItems")) {
                    DragonConfigHandler.rebuildSeaDragonConfigs();
                } else if (message.path.contains("forestBreathGrowBlacklist")) {
                    DragonConfigHandler.rebuildForestDragonConfigs();
                } else if (message.path.contains("BreathBlockBreaks")) {
                    DragonConfigHandler.rebuildBreathBlocks();
                } else if (message.path.contains("DragonManaBlocks")) {
                    DragonConfigHandler.rebuildManaBlocks();
                }
            });
        }
        context.setPacketHandled(true);
    }
}

