/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.config;

import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncNumberConfig
implements IMessage<SyncNumberConfig> {
    public String type;
    public String path;
    public Number value;

    public SyncNumberConfig() {
    }

    public SyncNumberConfig(String path, Number value) {
        this.path = path;
        this.value = value;
    }

    @Override
    public void encode(SyncNumberConfig message, FriendlyByteBuf buffer) {
        Number number = message.value;
        if (number instanceof Double) {
            Double doubleValue = (Double)number;
            buffer.m_130070_("DOUBLE");
            buffer.writeDouble(doubleValue.doubleValue());
        } else {
            number = message.value;
            if (number instanceof Long) {
                Long longValue = (Long)number;
                buffer.m_130070_("LONG");
                buffer.writeLong(longValue.longValue());
            } else {
                number = message.value;
                if (number instanceof Float) {
                    Float floatValue = (Float)number;
                    buffer.m_130070_("FLOAT");
                    buffer.writeFloat(floatValue.floatValue());
                } else {
                    number = message.value;
                    if (number instanceof Integer) {
                        Integer intValue = (Integer)number;
                        buffer.m_130070_("INTEGER");
                        buffer.writeInt(intValue.intValue());
                    }
                }
            }
        }
        buffer.m_130070_(message.path);
    }

    @Override
    public SyncNumberConfig decode(FriendlyByteBuf buffer) {
        String type;
        Number value = switch (type = buffer.m_130277_()) {
            case "DOUBLE" -> buffer.readDouble();
            case "LONG" -> buffer.readLong();
            case "FLOAT" -> Float.valueOf(buffer.readFloat());
            case "INTEGER" -> buffer.readInt();
            default -> 0;
        };
        String path = buffer.m_130277_();
        return new SyncNumberConfig(path, value);
    }

    @Override
    public void handle(SyncNumberConfig message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer sender = context.getSender();
            if (sender == null || !sender.m_20310_(2)) {
                context.setPacketHandled(true);
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new SyncNumberConfig(message.path, message.value));
        }
        Object object = ConfigHandler.serverSpec.getValues().get(message.path);
        context.enqueueWork(() -> {
            if (object instanceof ForgeConfigSpec.IntValue) {
                ForgeConfigSpec.IntValue intValue = (ForgeConfigSpec.IntValue)object;
                ConfigHandler.updateConfigValue((ForgeConfigSpec.ConfigValue)intValue, (Object)message.value.intValue());
            } else if (object instanceof ForgeConfigSpec.DoubleValue) {
                ForgeConfigSpec.DoubleValue doubleValue = (ForgeConfigSpec.DoubleValue)object;
                ConfigHandler.updateConfigValue((ForgeConfigSpec.ConfigValue)doubleValue, (Object)message.value.doubleValue());
            } else if (object instanceof ForgeConfigSpec.LongValue) {
                ForgeConfigSpec.LongValue longValue = (ForgeConfigSpec.LongValue)object;
                ConfigHandler.updateConfigValue((ForgeConfigSpec.ConfigValue)longValue, (Object)message.value.longValue());
            }
        });
        context.setPacketHandled(true);
    }
}

