/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.dragon_editor;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncDragonSkinSettings
implements IMessage<SyncDragonSkinSettings> {
    public int playerId;
    public boolean newborn;
    public boolean young;
    public boolean adult;

    public SyncDragonSkinSettings() {
    }

    public SyncDragonSkinSettings(int playerId, boolean newborn, boolean young, boolean adult) {
        this.playerId = playerId;
        this.newborn = newborn;
        this.young = young;
        this.adult = adult;
    }

    @Override
    public void encode(SyncDragonSkinSettings message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.newborn);
        buffer.writeBoolean(message.young);
        buffer.writeBoolean(message.adult);
    }

    @Override
    public SyncDragonSkinSettings decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        boolean newborn = buffer.readBoolean();
        boolean young = buffer.readBoolean();
        boolean adult = buffer.readBoolean();
        return new SyncDragonSkinSettings(playerId, newborn, young, adult);
    }

    @Override
    public void handle(SyncDragonSkinSettings message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncDragonSkinSettings(message));
        }
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                handler.getSkinData().renderNewborn = message.newborn;
                handler.getSkinData().renderYoung = message.young;
                handler.getSkinData().renderAdult = message.adult;
            });
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncDragonSkinSettings(sender.m_19879_(), message.newborn, message.young, message.adult));
        }
        context.setPacketHandled(true);
    }
}

