/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.dragon_editor;

import by.dragonsurvivalteam.dragonsurvival.client.skin_editor_system.objects.SkinPreset;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncPlayerSkinPreset
implements IMessage<SyncPlayerSkinPreset> {
    public int playerId;
    public SkinPreset preset;

    public SyncPlayerSkinPreset() {
    }

    public SyncPlayerSkinPreset(int playerId, SkinPreset preset) {
        this.playerId = playerId;
        this.preset = preset;
    }

    @Override
    public void encode(SyncPlayerSkinPreset message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.m_130079_(message.preset.writeNBT());
    }

    @Override
    public SyncPlayerSkinPreset decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        SkinPreset preset = new SkinPreset();
        preset.readNBT(buffer.m_130260_());
        return new SyncPlayerSkinPreset(playerId, preset);
    }

    @Override
    public void handle(SyncPlayerSkinPreset message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncPlayerSkinPreset(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            context.enqueueWork(() -> DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                handler.getSkinData().skinPreset = message.preset;
                handler.getSkinData().compileSkin();
            }));
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncPlayerSkinPreset(sender.m_19879_(), message.preset));
        }
        context.setPacketHandled(true);
    }
}

