/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.emotes;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.EmoteCap;
import by.dragonsurvivalteam.dragonsurvival.network.ISidedMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SyncEmote
extends ISidedMessage<SyncEmote> {
    private CompoundTag nbt;

    public SyncEmote(int playerId, EmoteCap cap) {
        super(playerId);
        this.nbt = cap.writeNBT();
    }

    public SyncEmote(int playerId, CompoundTag nbt) {
        super(playerId);
        this.nbt = nbt;
    }

    public SyncEmote() {
        super(-1);
    }

    @Override
    public void encode(SyncEmote message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.m_130079_(message.nbt);
    }

    @Override
    public SyncEmote decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        CompoundTag nbt = buffer.m_130260_();
        return new SyncEmote(playerId, nbt);
    }

    @Override
    public SyncEmote create(SyncEmote message) {
        return new SyncEmote(message.playerId, message.nbt);
    }

    @Override
    public void runCommon(SyncEmote message, NetworkEvent.Context context) {
    }

    @Override
    public void runServer(SyncEmote message, NetworkEvent.Context context, ServerPlayer sender) {
        context.enqueueWork(() -> DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> handler.getEmoteData().readNBT(message.nbt)));
    }

    @Override
    public void runClient(SyncEmote message, NetworkEvent.Context context, Player player) {
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> handler.getEmoteData().readNBT(message.nbt));
    }
}

