/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncFlightSpeed
implements IMessage<SyncFlightSpeed> {
    public int playerId;
    public Vec3 flightSpeed;

    public SyncFlightSpeed() {
    }

    public SyncFlightSpeed(int playerId, Vec3 flightSpeed) {
        this.playerId = playerId;
        this.flightSpeed = flightSpeed;
    }

    @Override
    public void encode(SyncFlightSpeed message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeDouble(message.flightSpeed.f_82479_);
        buffer.writeDouble(message.flightSpeed.f_82480_);
        buffer.writeDouble(message.flightSpeed.f_82481_);
    }

    @Override
    public SyncFlightSpeed decode(FriendlyByteBuf buffer) {
        return new SyncFlightSpeed(buffer.readInt(), new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()));
    }

    @Override
    public void handle(SyncFlightSpeed message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncFlightSpeed(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            context.enqueueWork(() -> {
                sender.m_20256_(message.flightSpeed);
                PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint(sender, sender.m_20182_().f_82479_, sender.m_20182_().f_82480_, sender.m_20182_().f_82481_, 32.0, sender.m_9236_().m_46472_());
                NetworkHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> point), (Object)new SyncFlightSpeed(sender.m_19879_(), message.flightSpeed));
            });
        }
        context.setPacketHandled(true);
    }
}

