/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncFlyingStatus
implements IMessage<SyncFlyingStatus> {
    public int playerId;
    public boolean state;

    public SyncFlyingStatus() {
    }

    public SyncFlyingStatus(int playerId, boolean state) {
        this.state = state;
        this.playerId = playerId;
    }

    @Override
    public void encode(SyncFlyingStatus message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.state);
    }

    @Override
    public SyncFlyingStatus decode(FriendlyByteBuf buffer) {
        return new SyncFlyingStatus(buffer.readInt(), buffer.readBoolean());
    }

    @Override
    public void handle(SyncFlyingStatus message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncFlyingStatus(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> handler.setWingsSpread(message.state));
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncFlyingStatus(sender.m_19879_(), message.state));
        }
        context.setPacketHandled(true);
    }
}

