/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.flight;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncSpinStatus
implements IMessage<SyncSpinStatus> {
    public int playerId;
    public int spinAttack;
    public int spinCooldown;
    public boolean spinLearned;

    public SyncSpinStatus(int playerId, int spinAttack, int spinCooldown, boolean spinLearned) {
        this.playerId = playerId;
        this.spinAttack = spinAttack;
        this.spinCooldown = spinCooldown;
        this.spinLearned = spinLearned;
    }

    public SyncSpinStatus() {
    }

    @Override
    public void encode(SyncSpinStatus message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeInt(message.spinAttack);
        buffer.writeInt(message.spinCooldown);
        buffer.writeBoolean(message.spinLearned);
    }

    @Override
    public SyncSpinStatus decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        int spinAttack = buffer.readInt();
        int spinCooldown = buffer.readInt();
        boolean spinLearned = buffer.readBoolean();
        return new SyncSpinStatus(playerId, spinAttack, spinCooldown, spinLearned);
    }

    @Override
    public void handle(SyncSpinStatus message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncSpinStatus(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                handler.getMovementData().spinAttack = message.spinAttack;
                handler.getMovementData().spinCooldown = message.spinCooldown;
                handler.getMovementData().spinLearned = message.spinLearned;
            });
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncSpinStatus(sender.m_19879_(), message.spinAttack, message.spinCooldown, message.spinLearned));
        }
        context.setPacketHandled(true);
    }
}

