/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.ActiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncAbilityCasting
implements IMessage<SyncAbilityCasting> {
    public int playerId;
    public boolean isCasting;
    public int abilitySlot;
    public CompoundTag nbt;
    public long castStartTime;
    public long clientTime;

    public SyncAbilityCasting() {
    }

    public SyncAbilityCasting(int playerId, boolean isCasting, int abilitySlot, CompoundTag nbt, long castStartTime, long clientTime) {
        this.playerId = playerId;
        this.isCasting = isCasting;
        this.abilitySlot = abilitySlot;
        this.nbt = nbt;
        this.castStartTime = castStartTime;
        this.clientTime = clientTime;
    }

    @Override
    public void encode(SyncAbilityCasting message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.isCasting);
        buffer.writeInt(message.abilitySlot);
        buffer.m_130079_(message.nbt);
        buffer.writeLong(message.castStartTime);
        buffer.writeLong(message.clientTime);
    }

    @Override
    public SyncAbilityCasting decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        return new SyncAbilityCasting(playerId, buffer.readBoolean(), buffer.readInt(), buffer.m_130260_(), buffer.readLong(), buffer.readLong());
    }

    @Override
    public void handle(SyncAbilityCasting message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncAbilityCasting(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                    ActiveDragonAbility ability = handler.getMagicData().getAbilityFromSlot(message.abilitySlot);
                    ability.loadNBT(message.nbt);
                    handler.getMagicData().isCasting = message.isCasting;
                    if (message.isCasting) {
                        ability.onKeyPressed((Player)sender, () -> {}, message.castStartTime, message.clientTime);
                    } else {
                        ability.onKeyReleased((Player)sender);
                    }
                });
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncAbilityCasting(sender.m_19879_(), message.isCasting, message.abilitySlot, message.nbt, message.castStartTime, message.clientTime));
            });
        }
        context.setPacketHandled(true);
    }
}

