/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.MagicCap;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncMagicCap
implements IMessage<SyncMagicCap> {
    public int playerId;
    public MagicCap cap;
    public CompoundTag nbt;

    public SyncMagicCap() {
    }

    public SyncMagicCap(int playerId, MagicCap cap) {
        this.cap = cap;
        this.playerId = playerId;
    }

    public SyncMagicCap(int playerId, CompoundTag nbt) {
        this.nbt = nbt;
        this.playerId = playerId;
    }

    @Override
    public void encode(SyncMagicCap message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.m_130079_(message.cap != null ? message.cap.writeNBT() : this.nbt);
    }

    @Override
    public SyncMagicCap decode(FriendlyByteBuf buffer) {
        return new SyncMagicCap(buffer.readInt(), buffer.m_130260_());
    }

    @Override
    public void handle(SyncMagicCap message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncMagicCap(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                    handler.getMagicData().readNBT(message.nbt);
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncMagicCap(sender.m_19879_(), handler.getMagicData()));
                });
            });
        }
        context.setPacketHandled(true);
    }
}

