/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.magic;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.magic.DragonAbilities;
import by.dragonsurvivalteam.dragonsurvival.magic.common.DragonAbility;
import by.dragonsurvivalteam.dragonsurvival.magic.common.passive.PassiveDragonAbility;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class SyncSkillLevelChangeCost
implements IMessage<SyncSkillLevelChangeCost> {
    private int level;
    private int levelChange;
    private String skill;

    public SyncSkillLevelChangeCost(int level, String skill, int levelChange) {
        this.level = level;
        this.skill = skill;
        this.levelChange = levelChange;
    }

    public SyncSkillLevelChangeCost() {
    }

    @Override
    public void encode(SyncSkillLevelChangeCost message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.level);
        buffer.m_130070_(message.skill);
        buffer.writeInt(message.levelChange);
    }

    @Override
    public SyncSkillLevelChangeCost decode(FriendlyByteBuf buffer) {
        int level = buffer.readInt();
        String skill = buffer.m_130277_();
        int levelChange = buffer.readInt();
        return new SyncSkillLevelChangeCost(level, skill, levelChange);
    }

    @Override
    public void handle(SyncSkillLevelChangeCost message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer sender = context.getSender();
        if (sender != null) {
            context.enqueueWork(() -> DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                DragonAbility staticAbility = DragonAbilities.ABILITY_LOOKUP.get(message.skill);
                if (staticAbility instanceof PassiveDragonAbility) {
                    int levelCost;
                    PassiveDragonAbility ability = (PassiveDragonAbility)staticAbility;
                    PassiveDragonAbility playerAbility = (PassiveDragonAbility)DragonAbilities.getSelfAbility((LivingEntity)sender, ability.getClass());
                    int n = levelCost = message.levelChange > 0 ? -playerAbility.getLevelCost(message.levelChange) : 0;
                    if (levelCost != 0 && !sender.m_7500_()) {
                        sender.m_6749_(levelCost);
                    }
                }
            }));
        }
        context.setPacketHandled(true);
    }
}

