/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.player;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncDragonMovement
implements IMessage<SyncDragonMovement> {
    public int playerId;
    public boolean isFirstPerson;
    public boolean bite;
    public boolean isFreeLook;
    public float desiredMoveVecX;
    public float desiredMoveVecY;

    public SyncDragonMovement() {
    }

    public SyncDragonMovement(int playerId, boolean isFirstPerson, boolean bite, boolean isFreeLook, float desiredMoveVecX, float desiredMoveVecY) {
        this.playerId = playerId;
        this.isFirstPerson = isFirstPerson;
        this.bite = bite;
        this.isFreeLook = isFreeLook;
        this.desiredMoveVecX = desiredMoveVecX;
        this.desiredMoveVecY = desiredMoveVecY;
    }

    @Override
    public void encode(SyncDragonMovement message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.isFirstPerson);
        buffer.writeBoolean(message.bite);
        buffer.writeBoolean(message.isFreeLook);
        buffer.writeFloat(message.desiredMoveVecX);
        buffer.writeFloat(message.desiredMoveVecY);
    }

    @Override
    public SyncDragonMovement decode(FriendlyByteBuf buffer) {
        return new SyncDragonMovement(buffer.readInt(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public void handle(SyncDragonMovement message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handlePacketSyncCapabilityMovement(message)).thenRun(() -> context.setPacketHandled(true));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ServerPlayer entity = context.getSender();
            ((CompletableFuture)context.enqueueWork(() -> SyncDragonMovement.lambda$handle$3((Entity)entity, message)).thenRun(() -> SyncDragonMovement.lambda$handle$5((Entity)entity, message))).thenRun(() -> context.setPacketHandled(true));
        }
    }

    private static /* synthetic */ void lambda$handle$5(Entity entity, SyncDragonMovement message) {
        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)message);
    }

    private static /* synthetic */ void lambda$handle$3(Entity entity, SyncDragonMovement message) {
        DragonStateProvider.getCap(entity).ifPresent(handler -> {
            handler.setFirstPerson(message.isFirstPerson);
            handler.setBite(message.bite);
            handler.setFreeLook(message.isFreeLook);
            handler.setDesiredMoveVec(new Vec2(message.desiredMoveVecX, message.desiredMoveVecY));
        });
    }
}

