/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.player;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SyncDragonTypeData
implements IMessage<SyncDragonTypeData> {
    public int playerId;
    public CompoundTag nbt;

    public SyncDragonTypeData() {
    }

    public SyncDragonTypeData(int playerId, CompoundTag nbt) {
        this.playerId = playerId;
        this.nbt = nbt;
    }

    public SyncDragonTypeData(int playerId, AbstractDragonType nbt) {
        this.playerId = playerId;
        this.nbt = nbt.writeNBT();
    }

    @Override
    public void encode(SyncDragonTypeData message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.m_130079_(message.nbt);
    }

    @Override
    public SyncDragonTypeData decode(FriendlyByteBuf buffer) {
        return new SyncDragonTypeData(buffer.readInt(), buffer.m_130260_());
    }

    @Override
    public void handle(SyncDragonTypeData message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncDragonTypeData(message));
        }
        context.setPacketHandled(true);
    }
}

