/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.player;

import by.dragonsurvivalteam.dragonsurvival.commands.DragonCommand;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonBodies;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SynchronizeDragonCap
implements IMessage<SynchronizeDragonCap> {
    public int playerId;
    public boolean hiding;
    public AbstractDragonType dragonType;
    public AbstractDragonBody dragonBody;
    public double size;
    public boolean hasWings;
    public int passengerId;

    public SynchronizeDragonCap() {
    }

    public SynchronizeDragonCap(int playerId, boolean hiding, AbstractDragonType dragonType, AbstractDragonBody dragonBody, double size, boolean hasWings, int passengerId) {
        this.playerId = playerId;
        this.hiding = hiding;
        this.dragonType = dragonType;
        this.dragonBody = dragonBody;
        this.size = size;
        this.hasWings = hasWings;
        this.passengerId = passengerId;
    }

    @Override
    public void encode(SynchronizeDragonCap message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.m_130070_(message.dragonType != null ? message.dragonType.getSubtypeName() : "none");
        buffer.m_130070_(message.dragonBody != null ? message.dragonBody.getBodyName() : "none");
        buffer.writeBoolean(message.hiding);
        buffer.writeDouble(message.size);
        buffer.writeBoolean(message.hasWings);
        buffer.writeInt(message.passengerId);
    }

    @Override
    public SynchronizeDragonCap decode(FriendlyByteBuf buffer) {
        int id = buffer.readInt();
        String typeS = buffer.m_130277_();
        String typeB = buffer.m_130277_();
        AbstractDragonType type = typeS.equals("none") ? null : DragonTypes.getStaticSubtype(typeS);
        AbstractDragonBody body = typeB.equals("none") ? null : DragonBodies.getStatic(typeB);
        boolean hiding = buffer.readBoolean();
        double size = buffer.readDouble();
        boolean hasWings = buffer.readBoolean();
        int passengerId = buffer.readInt();
        return new SynchronizeDragonCap(id, hiding, type, body, size, hasWings, passengerId);
    }

    @Override
    public void handle(SynchronizeDragonCap message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSynchronizeDragonCap(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
            context.enqueueWork(() -> {
                ServerPlayer sender = context.getSender();
                DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                    if (message.dragonType == null && handler.getType() != null) {
                        DragonCommand.reInsertClawTools((Player)sender, handler);
                    }
                    handler.setIsHiding(message.hiding);
                    handler.setType(message.dragonType, (Player)sender);
                    handler.setBody(message.dragonBody, (Player)sender);
                    handler.setSize(message.size, (Player)sender);
                    handler.setHasFlight(message.hasWings);
                    handler.setPassengerId(message.passengerId);
                });
            });
        }
        context.setPacketHandled(true);
    }
}

