/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.status;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncAltarCooldown
implements IMessage<SyncAltarCooldown> {
    public int playerId;
    public int cooldown;

    public SyncAltarCooldown() {
    }

    public SyncAltarCooldown(int playerId, int cooldown) {
        this.playerId = playerId;
        this.cooldown = cooldown;
    }

    @Override
    public void encode(SyncAltarCooldown message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeInt(message.cooldown);
    }

    @Override
    public SyncAltarCooldown decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        int cooldown = buffer.readInt();
        return new SyncAltarCooldown(playerId, cooldown);
    }

    @Override
    public void handle(SyncAltarCooldown message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncAltarCooldown(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)sender);
            handler.altarCooldown = message.cooldown;
            handler.hasUsedAltar = true;
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncAltarCooldown(sender.m_19879_(), message.cooldown));
        }
        context.setPacketHandled(true);
    }
}

