/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.status;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncMagicSourceStatus
implements IMessage<SyncMagicSourceStatus> {
    public int playerId;
    public boolean state;
    public int timer;

    public SyncMagicSourceStatus() {
    }

    public SyncMagicSourceStatus(int playerId, boolean state, int timer) {
        this.playerId = playerId;
        this.state = state;
        this.timer = timer;
    }

    @Override
    public void encode(SyncMagicSourceStatus message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.state);
        buffer.writeInt(message.timer);
    }

    @Override
    public SyncMagicSourceStatus decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        boolean state = buffer.readBoolean();
        int timer = buffer.readInt();
        return new SyncMagicSourceStatus(playerId, state, timer);
    }

    @Override
    public void handle(SyncMagicSourceStatus message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer sender;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncMagicSourceStatus(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (sender = context.getSender()) != null) {
            DragonStateProvider.getCap((Entity)sender).ifPresent(handler -> {
                handler.getMagicData().onMagicSource = message.state;
                handler.getMagicData().magicSourceTimer = message.timer;
            });
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sender), (Object)new SyncMagicSourceStatus(sender.m_19879_(), message.state, message.timer));
        }
        context.setPacketHandled(true);
    }
}

