/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.status;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.network.IMessage;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.client.ClientProxy;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class SyncTreasureRestStatus
implements IMessage<SyncTreasureRestStatus> {
    public int playerId;
    public boolean state;

    public SyncTreasureRestStatus() {
    }

    public SyncTreasureRestStatus(int playerId, boolean state) {
        this.playerId = playerId;
        this.state = state;
    }

    @Override
    public void encode(SyncTreasureRestStatus message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.writeBoolean(message.state);
    }

    @Override
    public SyncTreasureRestStatus decode(FriendlyByteBuf buffer) {
        int playerId = buffer.readInt();
        boolean state = buffer.readBoolean();
        return new SyncTreasureRestStatus(playerId, state);
    }

    @Override
    public void handle(SyncTreasureRestStatus message, Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer entity;
        NetworkEvent.Context context = supplier.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> ClientProxy.handleSyncTreasureRestStatus(message));
        } else if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER && (entity = context.getSender()) != null) {
            context.enqueueWork(() -> {
                DragonStateProvider.getCap((Entity)entity).ifPresent(handler -> {
                    boolean update = false;
                    if (message.state != handler.treasureResting) {
                        handler.treasureRestTimer = 0;
                        handler.treasureSleepTimer = 0;
                        update = true;
                    }
                    handler.treasureResting = message.state;
                    if (update) {
                        ((ServerLevel)entity.m_9236_()).m_8878_();
                    }
                });
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new SyncTreasureRestStatus(entity.m_19879_(), message.state));
            });
        }
        context.setPacketHandled(true);
    }
}

