/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.network.syncing;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.network.ISidedMessage;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonModifiers;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class CompleteDataSync
extends ISidedMessage<CompleteDataSync> {
    private CompoundTag nbt;

    public CompleteDataSync() {
        super(-1);
    }

    public CompleteDataSync(Player player) {
        super(player.m_19879_());
        DragonStateProvider.getCap((Entity)player).ifPresent(cap -> {
            this.nbt = cap.writeNBT();
        });
    }

    public CompleteDataSync(int playerId, CompoundTag nbt) {
        super(playerId);
        this.nbt = nbt;
    }

    @Override
    public void encode(CompleteDataSync message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.playerId);
        buffer.m_130079_(message.nbt);
    }

    @Override
    public CompleteDataSync decode(FriendlyByteBuf buffer) {
        return new CompleteDataSync(buffer.readInt(), buffer.m_130260_());
    }

    @Override
    public CompleteDataSync create(CompleteDataSync message) {
        return new CompleteDataSync(message.playerId, message.nbt);
    }

    @Override
    public void runCommon(CompleteDataSync message, NetworkEvent.Context context) {
    }

    @Override
    public void runServer(CompleteDataSync message, NetworkEvent.Context context, ServerPlayer player) {
        context.enqueueWork(() -> {
            DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
                SimpleContainer container = handler.getClawToolData().getClawsInventory();
                AbstractDragonType oldType = handler.getType();
                AbstractDragonBody oldBody = handler.getBody();
                double oldSize = handler.getSize();
                handler.readNBT(message.nbt);
                if (!DragonUtils.isDragonType(oldType, handler.getType())) {
                    DragonModifiers.updateTypeModifiers((Player)player);
                }
                if (oldBody != handler.getBody()) {
                    DragonModifiers.updateBodyModifiers((Player)player);
                }
                if (oldSize != handler.getSize()) {
                    DragonModifiers.updateSizeModifiers((Player)player);
                }
                handler.getClawToolData().setClawsInventory(container);
            });
            player.m_6210_();
        });
    }

    @Override
    public void runClient(CompleteDataSync message, NetworkEvent.Context context, Player player) {
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> handler.readNBT(message.nbt));
        player.m_6210_();
    }
}

