/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.magic.common.active.BreathAbility;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class DSDamageTypes {
    public static final ResourceKey<DamageType> WATER_BURN = DSDamageTypes.createKey("water_burn");
    public static final ResourceKey<DamageType> RAIN_BURN = DSDamageTypes.createKey("rain_burn");
    public static final ResourceKey<DamageType> DEHYDRATION = DSDamageTypes.createKey("dehydration");
    public static final ResourceKey<DamageType> SPECTRAL_IMPACT = DSDamageTypes.createKey("spectral_impact");
    public static final ResourceKey<DamageType> DRAGON_BREATH = DSDamageTypes.createKey("dragon_breath");
    public static final ResourceKey<DamageType> CAVE_DRAGON_BREATH = DSDamageTypes.createKey("cave_dragon_breath");
    public static final ResourceKey<DamageType> FOREST_DRAGON_BREATH = DSDamageTypes.createKey("forest_dragon_breath");
    public static final ResourceKey<DamageType> SEA_DRAGON_BREATH = DSDamageTypes.createKey("sea_dragon_breath");
    public static final ResourceKey<DamageType> FOREST_DRAGON_DRAIN = DSDamageTypes.createKey("forest_dragon_drain");
    public static final ResourceKey<DamageType> CAVE_DRAGON_BURN = DSDamageTypes.createKey("cave_dragon_burn");
    public static final ResourceKey<DamageType> DRAGON_BALL_LIGHTNING = DSDamageTypes.createKey("dragon_ball_lightning");
    public static final ResourceKey<DamageType> CRUSHED = DSDamageTypes.createKey("crushed");

    public static void bootstrap(BootstapContext<DamageType> context) {
        context.m_255272_(WATER_BURN, (Object)new DamageType("dragonsurvival.water_burn", 0.1f));
        context.m_255272_(RAIN_BURN, (Object)new DamageType("dragonsurvival.rain_burn", 0.1f));
        context.m_255272_(DEHYDRATION, (Object)new DamageType("dragonsurvival.dehydration", 0.1f));
        context.m_255272_(SPECTRAL_IMPACT, (Object)new DamageType("dragonsurvival.spectral_impact", 0.1f));
        context.m_255272_(DRAGON_BREATH, (Object)new DamageType("dragonsurvival.dragon_breath", 0.1f));
        context.m_255272_(CAVE_DRAGON_BREATH, (Object)new DamageType("cave_dragon_breath", 0.1f));
        context.m_255272_(FOREST_DRAGON_BREATH, (Object)new DamageType("forest_dragon_breath", 0.1f));
        context.m_255272_(SEA_DRAGON_BREATH, (Object)new DamageType("sea_dragon_breath", 0.1f));
        context.m_255272_(FOREST_DRAGON_DRAIN, (Object)new DamageType("dragonsurvival.forest_dragon_drain", 0.1f));
        context.m_255272_(CAVE_DRAGON_BURN, (Object)new DamageType("dragonsurvival.cave_dragon_burn", 0.1f));
        context.m_255272_(DRAGON_BALL_LIGHTNING, (Object)new DamageType("dragonsurvival.dragon_ball_lightning", 0.1f));
        context.m_255272_(CRUSHED, (Object)new DamageType("dragonsurvival.crushed", 0.1f));
    }

    public static DamageSource damageSource(Level level, ResourceKey<DamageType> damageType) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageType));
    }

    public static DamageSource entityDamageSource(Level level, ResourceKey<DamageType> damageType, Entity entity) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageType), entity);
    }

    public static DamageSource entityDamageSource(Level level, BreathAbility breathAbility, Entity entity) {
        return new DamageSource((Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DSDamageTypes.getBreathDamageType(breathAbility)), entity);
    }

    public static ResourceKey<DamageType> getBreathDamageType(BreathAbility breathAbility) {
        if (DragonUtils.isDragonType(breathAbility.getDragonType(), (AbstractDragonType)DragonTypes.CAVE)) {
            return CAVE_DRAGON_BREATH;
        }
        if (DragonUtils.isDragonType(breathAbility.getDragonType(), (AbstractDragonType)DragonTypes.FOREST)) {
            return FOREST_DRAGON_BREATH;
        }
        if (DragonUtils.isDragonType(breathAbility.getDragonType(), (AbstractDragonType)DragonTypes.SEA)) {
            return SEA_DRAGON_BREATH;
        }
        return DRAGON_BREATH;
    }

    private static ResourceKey<DamageType> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("dragonsurvival", name));
    }
}

