/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.entity.DragonEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.HunterHoundEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.KnightEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.PrinceHorseEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.PrincesHorseEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Princess;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.Shooter;
import by.dragonsurvivalteam.dragonsurvival.common.entity.creatures.SquireEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.BallLightningEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.Bolas;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.DragonSpikeEntity;
import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.FireBallEntity;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.VillagerRelationsHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DSEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"dragonsurvival");
    public static RegistryObject<EntityType<DragonEntity>> DRAGON = ENTITY_TYPES.register("dummy_dragon", () -> new EntityType(DragonEntity::new, MobCategory.MISC, true, false, false, false, ImmutableSet.of(), EntityDimensions.m_20398_((float)0.9f, (float)1.9f), 0, 0, FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_244571_)));
    public static RegistryObject<EntityType<DragonEntity>> DRAGON_ARMOR = ENTITY_TYPES.register("dragon_armor", () -> new EntityType(DragonEntity::new, MobCategory.MISC, true, false, false, false, ImmutableSet.of(), EntityDimensions.m_20398_((float)0.9f, (float)1.9f), 0, 0, FeatureFlagSet.m_247091_((FeatureFlag)FeatureFlags.f_244571_)));
    public static RegistryObject<EntityType<Bolas>> BOLAS_ENTITY = ENTITY_TYPES.register("bolas", () -> EntityType.Builder.m_20704_((entity, level) -> new Bolas(level), (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("bolas"));
    public static RegistryObject<EntityType<DragonSpikeEntity>> DRAGON_SPIKE = ENTITY_TYPES.register("dragon_spike", () -> EntityType.Builder.m_20704_(DragonSpikeEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(1).m_20712_("dragon_spike"));
    public static RegistryObject<EntityType<BallLightningEntity>> BALL_LIGHTNING = ENTITY_TYPES.register("ball_lightning", () -> EntityType.Builder.m_20704_(BallLightningEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(1).m_20712_("ball_lightning"));
    public static RegistryObject<EntityType<FireBallEntity>> FIREBALL = ENTITY_TYPES.register("fireball", () -> EntityType.Builder.m_20704_(FireBallEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(4).m_20717_(1).m_20712_("fireball"));
    public static RegistryObject<EntityType<HunterHoundEntity>> HUNTER_HOUND = ENTITY_TYPES.register("hunter_hound", () -> EntityType.Builder.m_20704_(HunterHoundEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 0.85f).m_20702_(64).m_20717_(1).m_20712_("hunter_hound"));
    public static RegistryObject<EntityType<Shooter>> SHOOTER_HUNTER = ENTITY_TYPES.register("shooter", () -> EntityType.Builder.m_20704_(Shooter::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(64).m_20717_(1).m_20712_("shooter"));
    public static RegistryObject<EntityType<SquireEntity>> SQUIRE_HUNTER = ENTITY_TYPES.register("squire", () -> EntityType.Builder.m_20704_(SquireEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20702_(64).m_20717_(1).m_20712_("squire"));
    public static RegistryObject<EntityType<Princess>> PRINCESS = ENTITY_TYPES.register("princess_entity", () -> EntityType.Builder.m_20704_(Princess::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.9f).m_20702_(64).m_20717_(1).m_20712_("princess_entity"));
    public static RegistryObject<EntityType<KnightEntity>> KNIGHT = ENTITY_TYPES.register("knight", () -> EntityType.Builder.m_20704_(KnightEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 2.5f).m_20702_(64).m_20717_(1).m_20712_("knight"));
    public static RegistryObject<EntityType<PrincesHorseEntity>> PRINCESS_ON_HORSE = ENTITY_TYPES.register("princess", () -> EntityType.Builder.m_20704_(PrincesHorseEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 2.5f).m_20702_(64).m_20717_(1).m_20712_("princess"));
    public static RegistryObject<EntityType<PrinceHorseEntity>> PRINCE_ON_HORSE = ENTITY_TYPES.register("prince", () -> EntityType.Builder.m_20704_(PrinceHorseEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.8f, 2.5f).m_20702_(64).m_20717_(1).m_20712_("prince"));
    public static VillagerProfession PRINCESS_PROFESSION;
    public static VillagerProfession PRINCE_PROFESSION;
    public static List<Item> SPAWN_EGGS;

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        if (key.equals(ForgeRegistries.Keys.VILLAGER_PROFESSIONS)) {
            DSEntities.registerVillageTypes(event);
        } else if (key.equals(ForgeRegistries.Keys.ITEMS)) {
            DSEntities.registerSpawnEggs(event);
        }
    }

    @SubscribeEvent
    public static void attributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)DRAGON.get(), DragonEntity.m_21183_().m_22265_());
        event.put((EntityType)DRAGON_ARMOR.get(), DragonEntity.m_21183_().m_22265_());
        event.put((EntityType)HUNTER_HOUND.get(), Wolf.m_30425_().m_22268_(Attributes.f_22279_, ServerConfig.houndSpeed.doubleValue()).m_22268_(Attributes.f_22281_, ServerConfig.houndDamage.doubleValue()).m_22268_(Attributes.f_22276_, ServerConfig.houndHealth.doubleValue()).m_22265_());
        event.put((EntityType)SHOOTER_HUNTER.get(), Pillager.m_33307_().m_22268_(Attributes.f_22279_, ServerConfig.hunterSpeed.doubleValue()).m_22268_(Attributes.f_22276_, ServerConfig.hunterHealth.doubleValue()).m_22268_(Attributes.f_22284_, ServerConfig.hunterArmor.doubleValue()).m_22268_(Attributes.f_22281_, ServerConfig.hunterDamage.doubleValue()).m_22265_());
        event.put((EntityType)SQUIRE_HUNTER.get(), Vindicator.m_34104_().m_22268_(Attributes.f_22279_, ServerConfig.squireSpeed.doubleValue()).m_22268_(Attributes.f_22281_, ServerConfig.squireDamage.doubleValue()).m_22268_(Attributes.f_22284_, ServerConfig.squireArmor.doubleValue()).m_22268_(Attributes.f_22276_, ServerConfig.squireHealth.doubleValue()).m_22265_());
        event.put((EntityType)KNIGHT.get(), KnightEntity.m_21552_().m_22268_(Attributes.f_22279_, ServerConfig.knightSpeed.doubleValue()).m_22268_(Attributes.f_22281_, ServerConfig.knightDamage.doubleValue()).m_22268_(Attributes.f_22284_, ServerConfig.knightArmor.doubleValue()).m_22268_(Attributes.f_22276_, ServerConfig.knightHealth.doubleValue()).m_22265_());
        event.put((EntityType)PRINCESS.get(), Villager.m_35503_().m_22268_(Attributes.f_22276_, ServerConfig.princessHealth.doubleValue()).m_22268_(Attributes.f_22284_, ServerConfig.princessArmor.doubleValue()).m_22268_(Attributes.f_22279_, ServerConfig.princessSpeed.doubleValue()).m_22265_());
        event.put((EntityType)PRINCESS_ON_HORSE.get(), Villager.m_35503_().m_22268_(Attributes.f_22276_, ServerConfig.princessHealth.doubleValue()).m_22268_(Attributes.f_22284_, ServerConfig.princessArmor.doubleValue()).m_22268_(Attributes.f_22279_, ServerConfig.princessSpeed.doubleValue()).m_22265_());
        event.put((EntityType)PRINCE_ON_HORSE.get(), Villager.m_35503_().m_22268_(Attributes.f_22281_, ServerConfig.princeDamage.doubleValue()).m_22268_(Attributes.f_22276_, ServerConfig.princeHealth.doubleValue()).m_22268_(Attributes.f_22284_, ServerConfig.princeArmor.doubleValue()).m_22268_(Attributes.f_22279_, ServerConfig.princeSpeed.doubleValue()).m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawn(SpawnPlacementRegisterEvent event) {
        SpawnPlacements.SpawnPredicate predicate = (pEntityType, serverWorld, mobSpawnType, pPos, random) -> serverWorld.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184228_) && serverWorld.m_45527_(pPos);
        SpawnPlacements.SpawnPredicate princeSpawn = (pEntityType, serverWorld, mobSpawnType, pPos, random) -> predicate.m_217080_(pEntityType, serverWorld, mobSpawnType, pPos, random) && serverWorld.m_6018_().m_8802_(pPos);
        event.register((EntityType)SHOOTER_HUNTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)SQUIRE_HUNTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)KNIGHT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, predicate, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)PRINCE_ON_HORSE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, princeSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)PRINCESS_ON_HORSE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, princeSpawn, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public static <T extends RegistryObject<EntityType<? extends PathfinderMob>>> T castToPathFinder(RegistryObject entityType) {
        return (T)entityType;
    }

    public static <T extends RegistryObject<EntityType<? extends Mob>>> T castToMob(RegistryObject entityType) {
        return (T)entityType;
    }

    public static void registerVillageTypes(RegisterEvent ignored) {
        PRINCESS_PROFESSION = new VillagerProfession("princess", PoiType.f_218034_, PoiType.f_218034_, ImmutableSet.of(), ImmutableSet.of(), null);
        PRINCE_PROFESSION = new VillagerProfession("prince", PoiType.f_218034_, PoiType.f_218034_, ImmutableSet.of(), ImmutableSet.of(), null);
    }

    public static void registerSpawnEggs(RegisterEvent event) {
        DSEntities.registerSpawnEgg(event, DSEntities.castToMob(HUNTER_HOUND), 10510648, 8934192);
        DSEntities.registerSpawnEgg(event, DSEntities.castToMob(SHOOTER_HUNTER), 12486764, 2690565);
        DSEntities.registerSpawnEgg(event, DSEntities.castToMob(SQUIRE_HUNTER), 12486764, 5318420);
        DSEntities.registerSpawnEgg(event, DSEntities.castToMob(KNIGHT), -15526631, -8750470);
        DSEntities.registerSpawnEgg(event, DSEntities.castToMob(PRINCE_ON_HORSE), -14210026, -9571315);
        DSEntities.registerSpawnEgg(event, DSEntities.castToMob(PRINCESS_ON_HORSE), -14804205, -14047);
    }

    private static void registerSpawnEgg(RegisterEvent event, RegistryObject<EntityType<? extends Mob>> entity, int eggPrimary, int eggSecondary) {
        ForgeSpawnEggItem spawnEgg = new ForgeSpawnEggItem(entity, eggPrimary, eggSecondary, new Item.Properties());
        event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("dragonsurvival", entity.getKey().m_135782_().m_135815_() + "_spawn_egg"), () -> DSEntities.lambda$registerSpawnEgg$16((Item)spawnEgg));
        SPAWN_EGGS.add((Item)spawnEgg);
    }

    private static /* synthetic */ Item lambda$registerSpawnEgg$16(Item spawnEgg) {
        return spawnEgg;
    }

    static {
        VillagerRelationsHandler.dragonHunters = new ArrayList<Supplier<EntityType<? extends PathfinderMob>>>(4);
        if (ServerConfig.spawnHound.booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((Supplier<EntityType<? extends PathfinderMob>>)DSEntities.castToPathFinder(HUNTER_HOUND));
        }
        if (ServerConfig.spawnSquire.booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((Supplier<EntityType<? extends PathfinderMob>>)DSEntities.castToPathFinder(SQUIRE_HUNTER));
        }
        if (ServerConfig.spawnHunter.booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((Supplier<EntityType<? extends PathfinderMob>>)DSEntities.castToPathFinder(SHOOTER_HUNTER));
        }
        if (ServerConfig.spawnKnight.booleanValue()) {
            VillagerRelationsHandler.dragonHunters.add((Supplier<EntityType<? extends PathfinderMob>>)DSEntities.castToPathFinder(KNIGHT));
        }
        SPAWN_EGGS = new ArrayList<Item>();
    }
}

