/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.types.SeaDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.items.ChargedCoalItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.DragonTreatItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.RoyalSummonItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.SpinGrantItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.WingGrantItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.food.ChargedSoupItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.food.DragonFoodItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.growth.StarBoneItem;
import by.dragonsurvivalteam.dragonsurvival.common.items.growth.StarHeartItem;
import by.dragonsurvivalteam.dragonsurvival.registry.DSEntities;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.BlockPosHelper;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="dragonsurvival", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DSItems {
    public static HashMap<String, Item> DS_ITEMS = new HashMap();
    public static Item dragonHeartShard;
    public static Item weakDragonHeart;
    public static Item elderDragonHeart;
    public static Item starBone;
    public static Item elderDragonBone;
    public static Item elderDragonDust;
    public static Item princeSummon;
    public static Item princessSummon;
    public static Item charredMeat;
    public static Item charredVegetable;
    public static Item charredMushroom;
    public static Item charredSeafood;
    public static Item chargedCoal;
    public static Item chargedSoup;
    public static Item hotDragonRod;
    public static Item explosiveCopper;
    public static Item doubleQuartz;
    public static Item quartzExplosiveCopper;
    public static Item meatChorusMix;
    public static Item meatWildBerries;
    public static Item smellyMeatPorridge;
    public static Item diamondChorus;
    public static Item luminousOintment;
    public static Item sweetSourRabbit;
    public static Item seasonedFish;
    public static Item goldenCoralPufferfish;
    public static Item frozenRawFish;
    public static Item goldenTurtleEgg;
    public static Item seaDragonTreat;
    public static Item caveDragonTreat;
    public static Item forestDragonTreat;
    public static Item huntingNet;
    public static Item passiveFireBeacon;
    public static Item passiveMagicBeacon;
    public static Item passivePeaceBeacon;
    public static Item starHeart;
    public static Item wingGrantItem;
    public static Item spinGrantItem;
    public static Item lightningTextureItem;
    public static Item inactivePeaceDragonBeacon;
    public static Item inactiveMagicDragonBeacon;
    public static Item inactiveFireDragonBeacon;

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        if (!Objects.equals(event.getForgeRegistry(), ForgeRegistries.ITEMS)) {
            return;
        }
        Item.Properties defaultProperties = new Item.Properties();
        starBone = DSItems.registerItem(event, new StarBoneItem(defaultProperties), "star_bone");
        starHeart = DSItems.registerItem(event, new StarHeartItem(defaultProperties), "star_heart");
        elderDragonDust = DSItems.registerItem(event, "elder_dragon_dust", "ds.description.elderDragonDust");
        elderDragonBone = DSItems.registerItem(event, "elder_dragon_bone", "ds.description.elderDragonBone");
        princeSummon = DSItems.registerItem(event, new RoyalSummonItem((Supplier<EntityType<? extends Mob>>)DSEntities.castToMob(DSEntities.PRINCE_ON_HORSE), defaultProperties), "prince_summon");
        princessSummon = DSItems.registerItem(event, new RoyalSummonItem((Supplier<EntityType<? extends Mob>>)DSEntities.castToMob(DSEntities.PRINCESS_ON_HORSE), defaultProperties), "princess_summon");
        dragonHeartShard = DSItems.registerItem(event, "heart_element", "ds.description.heartElement");
        weakDragonHeart = DSItems.registerItem(event, "weak_dragon_heart", "ds.description.weakDragonHeart");
        elderDragonHeart = DSItems.registerItem(event, "elder_dragon_heart", "ds.description.elderDragonHeart");
        chargedCoal = DSItems.registerItem(event, new ChargedCoalItem(defaultProperties, (AbstractDragonType)DragonTypes.CAVE, LivingEntity::m_21219_), "charged_coal");
        chargedSoup = DSItems.registerItem(event, new ChargedSoupItem(defaultProperties), "charged_soup");
        charredMeat = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "charred_meat");
        charredVegetable = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "charred_vegetable");
        charredMushroom = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "charred_mushroom");
        charredSeafood = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "charred_seafood");
        hotDragonRod = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.CAVE, () -> new MobEffectInstance(DragonEffects.FIRE, Functions.minutesToTicks(1))), "hot_dragon_rod");
        explosiveCopper = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, null, e -> {
            e.m_6469_(e.m_269291_().m_269036_((Entity)e, (Entity)e), 1.0f);
            e.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123813_, e.m_20185_(), e.m_20188_(), e.m_20189_(), 1.0, 0.0, 0.0);
            e.m_9236_().m_5594_(null, BlockPosHelper.get(e.m_146892_()), SoundEvents.f_11935_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }), "explosive_copper");
        quartzExplosiveCopper = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.CAVE, e -> {
            e.m_21195_(MobEffects.f_19614_);
            e.m_21195_(MobEffects.f_19615_);
        }, () -> new MobEffectInstance(MobEffects.f_19617_, Functions.minutesToTicks(5)), () -> new MobEffectInstance(MobEffects.f_19605_, Functions.secondsToTicks(10), 1)), "quartz_explosive_copper");
        doubleQuartz = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.CAVE, () -> new MobEffectInstance(MobEffects.f_19605_, Functions.secondsToTicks(5))), "double_quartz");
        sweetSourRabbit = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.FOREST, LivingEntity::m_21219_), "sweet_sour_rabbit");
        luminousOintment = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.FOREST, () -> new MobEffectInstance(MobEffects.f_19619_, Functions.minutesToTicks(5)), () -> new MobEffectInstance(DragonEffects.MAGIC, Functions.minutesToTicks(5))), "luminous_ointment");
        diamondChorus = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.FOREST, e -> {
            e.m_21195_(MobEffects.f_19614_);
            e.m_21195_(MobEffects.f_19615_);
        }, () -> new MobEffectInstance(MobEffects.f_19617_, Functions.minutesToTicks(5)), () -> new MobEffectInstance(MobEffects.f_19605_, Functions.secondsToTicks(10), 1)), "diamond_chorus");
        smellyMeatPorridge = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "smelly_meat_porridge");
        meatWildBerries = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "meat_wild_berries");
        meatChorusMix = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.FOREST, () -> new MobEffectInstance(MobEffects.f_19605_, Functions.secondsToTicks(5))), "meat_chorus_mix");
        seasonedFish = DSItems.registerItem(event, new DragonFoodItem(defaultProperties), "seasoned_fish");
        goldenCoralPufferfish = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.SEA, () -> new MobEffectInstance(MobEffects.f_19605_, Functions.secondsToTicks(5))), "golden_coral_pufferfish");
        frozenRawFish = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.SEA, e -> {
            AbstractDragonType patt7819$temp;
            e.m_21219_();
            if (!e.m_9236_().m_5776_() && (patt7819$temp = DragonUtils.getHandler((Entity)e).getType()) instanceof SeaDragonType) {
                SeaDragonType type = (SeaDragonType)patt7819$temp;
                type.timeWithoutWater = 0.0;
            }
        }), "frozen_raw_fish");
        goldenTurtleEgg = DSItems.registerItem(event, new DragonFoodItem(defaultProperties, (AbstractDragonType)DragonTypes.SEA, e -> {
            e.m_21195_(MobEffects.f_19614_);
            e.m_21195_(MobEffects.f_19615_);
        }, () -> new MobEffectInstance(MobEffects.f_19617_, Functions.minutesToTicks(5)), () -> new MobEffectInstance(MobEffects.f_19605_, Functions.secondsToTicks(10), 1)), "golden_turtle_egg");
        seaDragonTreat = DSItems.registerItem(event, new DragonTreatItem(DragonTypes.SEA, defaultProperties), "sea_dragon_treat");
        caveDragonTreat = DSItems.registerItem(event, new DragonTreatItem(DragonTypes.CAVE, defaultProperties), "cave_dragon_treat");
        forestDragonTreat = DSItems.registerItem(event, new DragonTreatItem(DragonTypes.FOREST, defaultProperties), "forest_dragon_treat");
        huntingNet = DSItems.registerItem(event, new Item(new Item.Properties()), "dragon_hunting_mesh");
        lightningTextureItem = DSItems.registerItem(event, new Item(new Item.Properties()), "lightning");
        passiveMagicBeacon = DSItems.registerItem(event, new Item(new Item.Properties()), "beacon_magic_1");
        passivePeaceBeacon = DSItems.registerItem(event, new Item(new Item.Properties()), "beacon_peace_1");
        passiveFireBeacon = DSItems.registerItem(event, new Item(new Item.Properties()), "beacon_fire_1");
        inactiveMagicDragonBeacon = DSItems.registerItem(event, new Item(new Item.Properties()), "beacon_magic_0");
        inactivePeaceDragonBeacon = DSItems.registerItem(event, new Item(new Item.Properties()), "beacon_peace_0");
        inactiveFireDragonBeacon = DSItems.registerItem(event, new Item(new Item.Properties()), "beacon_fire_0");
        wingGrantItem = DSItems.registerItem(event, new WingGrantItem(defaultProperties), "wing_grant");
        spinGrantItem = DSItems.registerItem(event, new SpinGrantItem(defaultProperties), "spin_grant");
    }

    public static Item registerItem(RegisterEvent event, String name, final String description) {
        Item item = new Item(new Item.Properties()){

            public void m_7373_(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> list, @NotNull TooltipFlag tooltipFlag) {
                super.m_7373_(stack, world, list, tooltipFlag);
                list.add((Component)Component.m_237115_((String)description));
            }
        };
        event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("dragonsurvival", name), () -> item);
        DS_ITEMS.put(name, item);
        return item;
    }

    public static Item registerItem(RegisterEvent event, Item item, String name) {
        event.register(ForgeRegistries.Keys.ITEMS, new ResourceLocation("dragonsurvival", name), () -> item);
        DS_ITEMS.put(name, item);
        return item;
    }
}

