/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.entity.projectiles.Bolas;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.magic.abilities.CaveDragon.active.ToughSkinAbility;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DragonEffects {
    public static MobEffect STRESS;
    public static MobEffect TRAPPED;
    public static MobEffect ROYAL_CHASE;
    public static MobEffect PEACE;
    public static MobEffect MAGIC;
    public static MobEffect FIRE;
    public static MobEffect ANIMAL_PEACE;
    public static MobEffect SOURCE_OF_MAGIC;
    public static MobEffect ROYAL_DEPARTURE;
    public static MobEffect WATER_VISION;
    public static MobEffect LAVA_VISION;
    public static MobEffect HUNTER;
    public static MobEffect REVEALING_THE_SOUL;
    public static MobEffect BURN;
    public static MobEffect CHARGED;
    public static MobEffect DRAIN;
    public static MobEffect STRONG_LEATHER;
    public static MobEffect cave_wings;
    public static MobEffect sea_wings;
    public static MobEffect forest_wings;

    @SubscribeEvent
    public static void registerEffects(RegisterEvent event) {
        if (!event.getRegistryKey().equals(ForgeRegistries.Keys.MOB_EFFECTS)) {
            return;
        }
        STRESS = DragonEffects.registerMobEffect(event, "stress", new Stress(16032488));
        TRAPPED = DragonEffects.registerMobEffect(event, "trapped", new Trapped(MobEffectCategory.HARMFUL, 0xDDDDDD, true));
        ROYAL_CHASE = DragonEffects.registerMobEffect(event, "royal_chase", new RoyalChase(MobEffectCategory.NEUTRAL));
        PEACE = DragonEffects.registerMobEffect(event, "peace", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        MAGIC = DragonEffects.registerMobEffect(event, "magic", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        FIRE = DragonEffects.registerMobEffect(event, "fire", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        ANIMAL_PEACE = DragonEffects.registerMobEffect(event, "animal_peace", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        SOURCE_OF_MAGIC = DragonEffects.registerMobEffect(event, "source_of_magic", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        ROYAL_DEPARTURE = DragonEffects.registerMobEffect(event, "royal_departure", new TradeEffect(MobEffectCategory.HARMFUL, -3407617, true));
        WATER_VISION = DragonEffects.registerMobEffect(event, "water_vision", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        LAVA_VISION = DragonEffects.registerMobEffect(event, "lava_vision", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        HUNTER = DragonEffects.registerMobEffect(event, "hunter", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        REVEALING_THE_SOUL = DragonEffects.registerMobEffect(event, "revealing_the_soul", new Effect2(MobEffectCategory.BENEFICIAL, 0, false));
        STRONG_LEATHER = DragonEffects.registerMobEffect(event, "strong_leather", new Effect2(MobEffectCategory.BENEFICIAL, 0, false).m_19472_(Attributes.f_22284_, "1640719a-4c40-11ec-81d3-0242ac130003", ToughSkinAbility.toughSkinArmorValue, AttributeModifier.Operation.ADDITION));
        BURN = DragonEffects.registerMobEffect(event, "burn", new Effect2(MobEffectCategory.HARMFUL, 0, false));
        CHARGED = DragonEffects.registerMobEffect(event, "charged", new Effect2(MobEffectCategory.HARMFUL, 0, false));
        DRAIN = DragonEffects.registerMobEffect(event, "drain", new Effect2(MobEffectCategory.HARMFUL, 0, false));
        forest_wings = DragonEffects.registerMobEffect(event, "wings_forest", new Effect2(MobEffectCategory.BENEFICIAL, 0, true));
        sea_wings = DragonEffects.registerMobEffect(event, "wings_sea", new Effect2(MobEffectCategory.BENEFICIAL, 0, true));
        cave_wings = DragonEffects.registerMobEffect(event, "wings_cave", new Effect2(MobEffectCategory.BENEFICIAL, 0, true));
    }

    protected static MobEffect registerMobEffect(RegisterEvent event, String identity, MobEffect mobEffect) {
        event.register(ForgeRegistries.Keys.MOB_EFFECTS, new ResourceLocation("dragonsurvival", identity), () -> mobEffect);
        return mobEffect;
    }

    private static class Stress
    extends MobEffect {
        protected Stress(int color) {
            super(MobEffectCategory.HARMFUL, color);
        }

        public void m_6742_(LivingEntity living, int p_76394_2_) {
            if (living instanceof Player) {
                Player player = (Player)living;
                FoodData food = player.m_36324_();
                if (food.m_38722_() > 0.0f) {
                    int oldFood = food.m_38702_();
                    food.m_38707_(1, (float)((double)(-0.5f * food.m_38722_()) * ServerConfig.stressExhaustion));
                    if (oldFood != 20) {
                        food.m_38705_((int)((double)food.m_38702_() - 1.0 * ServerConfig.stressExhaustion));
                    }
                }
                player.m_36399_((float)(1.0 * ServerConfig.stressExhaustion));
            }
        }

        public boolean m_6584_(int p_76397_1_, int p_76397_2_) {
            int i = 20 >> p_76397_2_;
            if (i > 0) {
                return p_76397_1_ % i == 0;
            }
            return true;
        }
    }

    private static class Trapped
    extends MobEffect {
        protected Trapped(MobEffectCategory effectType, int color, boolean uncurable) {
            super(effectType, color);
        }

        public List<ItemStack> getCurativeItems() {
            return Collections.emptyList();
        }

        public void m_6742_(LivingEntity living, int strength) {
            living.m_21051_(Attributes.f_22279_).m_22120_(Bolas.SLOW_MOVEMENT);
        }

        public boolean m_6584_(int timeLeft, int p_76397_2_) {
            return timeLeft == 1;
        }
    }

    private static class RoyalChase
    extends MobEffect {
        protected RoyalChase(MobEffectCategory p_i50391_1_) {
            super(p_i50391_1_, 0);
        }

        public List<ItemStack> getCurativeItems() {
            return Collections.emptyList();
        }
    }

    private static class Effect2
    extends MobEffect {
        private final boolean uncurable;

        protected Effect2(MobEffectCategory type, int color, boolean uncurable) {
            super(type, color);
            this.uncurable = uncurable;
        }

        public List<ItemStack> getCurativeItems() {
            return this.uncurable ? Collections.emptyList() : super.getCurativeItems();
        }
    }

    private static class TradeEffect
    extends MobEffect {
        private final boolean uncurable;

        protected TradeEffect(MobEffectCategory type, int color, boolean uncurable) {
            super(type, color);
            this.uncurable = uncurable;
        }

        public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
            super.m_6386_(entity, attributeMap, amplifier);
            if (entity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ENTITY_TYPES, (ResourceLocation)new ResourceLocation("dragonsurvival:royal_departure_affected"))) && !entity.m_9236_().m_5776_()) {
                entity.m_146870_();
            }
        }

        public boolean m_6584_(int duration, int amplifier) {
            return true;
        }
    }
}

