/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.registry;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DragonModifiers {
    private static final UUID DRAGON_REACH_MODIFIER = UUID.fromString("7455d5c7-4e1f-4cca-ab46-d79353764020");
    private static final UUID DRAGON_HEALTH_MODIFIER = UUID.fromString("03574e62-f9e4-4f1b-85ad-fde00915e446");
    private static final UUID DRAGON_DAMAGE_MODIFIER = UUID.fromString("5bd3cebc-132e-4f9d-88ef-b686c7ad1e2c");
    private static final UUID DRAGON_SWIM_SPEED_MODIFIER = UUID.fromString("2a9341f3-d19e-446c-924b-7cf2e5259e10");
    private static final UUID DRAGON_STEP_HEIGHT_MODIFIER = UUID.fromString("f3b0b3e3-3b7d-4b1b-8f3d-3b7d4b1b8f3d");
    private static final UUID DRAGON_MOVEMENT_SPEED_MODIFIER = UUID.fromString("a11bba07-27e2-4c98-ac2c-34ae9f9b0694");
    private static final UUID DRAGON_BODY_MOVEMENT_SPEED = UUID.fromString("114fe18b-60fd-4284-b6ce-14d090454402");
    private static final UUID DRAGON_BODY_ARMOR = UUID.fromString("8728438d-c838-4968-9382-efb95a36d72a");
    private static final UUID DRAGON_BODY_STRENGTH = UUID.fromString("f591516e-749d-41f3-ba5a-b94cdf506193");
    private static final UUID DRAGON_BODY_STRENGTH_MULT = UUID.fromString("05a4e0c8-f76b-45db-a244-3d588146a4ab");
    private static final UUID DRAGON_BODY_KNOCKBACK_BONUS = UUID.fromString("f33f6ac0-2dd8-41a6-abe0-37e5cd0a383c");
    private static final UUID DRAGON_BODY_SWIM_SPEED_BONUS = UUID.fromString("244edf11-e535-4dc1-b8a0-4f56a5a80e0c");
    private static final UUID DRAGON_BODY_STEP_HEIGHT_BONUS = UUID.fromString("df2b333e-46c8-4315-a50d-096785e4f592");
    private static final UUID DRAGON_BODY_GRAVITY_MULT = UUID.fromString("de994497-1cca-45e6-b398-a1736f43e5ec");
    private static final UUID DRAGON_BODY_HEALTH_MULT = UUID.fromString("9068f914-511d-44cf-a2a3-0808f7c67326");

    public static AttributeModifier buildHealthMod(double size) {
        double healthModifier;
        if (ServerConfig.allowLargeScaling.booleanValue() && size > (double)ServerConfig.maxHealthSize.intValue()) {
            double healthModifierPercentage = Math.min(1.0, (size - (double)ServerConfig.maxHealthSize.intValue()) / (ServerConfig.maxGrowthSize - (double)DragonLevel.ADULT.size));
            healthModifier = Mth.m_14139_((double)healthModifierPercentage, (double)ServerConfig.maxHealth.intValue(), (double)ServerConfig.largeMaxHealth.intValue()) - 20.0;
        } else {
            double healthModifierPercentage = Math.min(1.0, (size - (double)DragonLevel.NEWBORN.size) / (double)(ServerConfig.maxHealthSize - DragonLevel.NEWBORN.size));
            healthModifier = Mth.m_14139_((double)healthModifierPercentage, (double)ServerConfig.minHealth.intValue(), (double)ServerConfig.maxHealth.intValue()) - 20.0;
        }
        return new AttributeModifier(DRAGON_HEALTH_MODIFIER, "Dragon Health Adjustment", healthModifier, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier buildReachMod(double size) {
        double reachModifier = ServerConfig.allowLargeScaling != false && size > ServerConfig.DEFAULT_MAX_GROWTH_SIZE ? ServerConfig.reachBonus + ServerConfig.largeReachScalar * (size / ServerConfig.DEFAULT_MAX_GROWTH_SIZE) : Math.max(ServerConfig.reachBonus, (size - (double)DragonLevel.NEWBORN.size) / (ServerConfig.DEFAULT_MAX_GROWTH_SIZE - (double)DragonLevel.NEWBORN.size) * ServerConfig.reachBonus);
        return new AttributeModifier(DRAGON_REACH_MODIFIER, "Dragon Reach Adjustment", reachModifier, AttributeModifier.Operation.MULTIPLY_BASE);
    }

    public static AttributeModifier buildDamageMod(DragonStateHandler handler, boolean isDragon) {
        double ageBonus;
        double d = isDragon ? (handler.getLevel() == DragonLevel.ADULT ? ServerConfig.adultBonusDamage : (handler.getLevel() == DragonLevel.YOUNG ? ServerConfig.youngBonusDamage : ServerConfig.babyBonusDamage)) : (ageBonus = 0.0);
        if (ServerConfig.allowLargeScaling.booleanValue() && handler.getSize() > ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
            double damageModPercentage = Math.min(1.0, (handler.getSize() - ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / (ServerConfig.maxGrowthSize - ServerConfig.DEFAULT_MAX_GROWTH_SIZE));
            ageBonus = Mth.m_14139_((double)damageModPercentage, (double)ageBonus, (double)ServerConfig.largeDamageBonus);
        }
        return new AttributeModifier(DRAGON_DAMAGE_MODIFIER, "Dragon Damage Adjustment", ageBonus, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier buildSwimSpeedMod(AbstractDragonType dragonType) {
        return new AttributeModifier(DRAGON_SWIM_SPEED_MODIFIER, "Dragon Swim Speed Adjustment", Objects.equals(dragonType, DragonTypes.SEA) && ServerConfig.seaSwimmingBonuses != false ? 1.0 : 0.0, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier buildStepHeightMod(DragonStateHandler handler, double size) {
        double stepHeightBonus = handler.getLevel() == DragonLevel.ADULT ? ServerConfig.adultStepHeight : (handler.getLevel() == DragonLevel.YOUNG ? ServerConfig.youngStepHeight : ServerConfig.newbornStepHeight);
        if (size > ServerConfig.DEFAULT_MAX_GROWTH_SIZE && ServerConfig.allowLargeScaling.booleanValue()) {
            stepHeightBonus += ServerConfig.largeStepHeightScalar * (size - ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / ServerConfig.DEFAULT_MAX_GROWTH_SIZE;
        }
        return new AttributeModifier(DRAGON_STEP_HEIGHT_MODIFIER, "Dragon Step Height Adjustment", stepHeightBonus, AttributeModifier.Operation.ADDITION);
    }

    public static AttributeModifier buildMovementSpeedMod(DragonStateHandler handler, double size) {
        double moveSpeedMultiplier = 1.0;
        if (handler.getLevel() == DragonLevel.NEWBORN) {
            double youngPercent = Math.min(1.0, (size - (double)DragonLevel.NEWBORN.size) / (double)(DragonLevel.YOUNG.size - DragonLevel.NEWBORN.size));
            moveSpeedMultiplier = Mth.m_14139_((double)youngPercent, (double)ServerConfig.moveSpeedNewborn, (double)ServerConfig.moveSpeedYoung);
        } else if (handler.getLevel() == DragonLevel.YOUNG) {
            double adultPercent = Math.min(1.0, (size - (double)DragonLevel.YOUNG.size) / (double)(DragonLevel.ADULT.size - DragonLevel.YOUNG.size));
            moveSpeedMultiplier = Mth.m_14139_((double)adultPercent, (double)ServerConfig.moveSpeedYoung, (double)ServerConfig.moveSpeedAdult);
        } else if (handler.getLevel() == DragonLevel.ADULT) {
            moveSpeedMultiplier = ServerConfig.allowLargeScaling != false && size > ServerConfig.DEFAULT_MAX_GROWTH_SIZE ? ServerConfig.moveSpeedAdult + ServerConfig.largeMovementSpeedScalar * (size - ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / ServerConfig.DEFAULT_MAX_GROWTH_SIZE : ServerConfig.moveSpeedAdult;
        }
        return new AttributeModifier(DRAGON_MOVEMENT_SPEED_MODIFIER, "Dragon Movement Speed Adjustment", moveSpeedMultiplier - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public static void updateModifiers(Player player) {
        DragonModifiers.updateTypeModifiers(player);
        DragonModifiers.updateSizeModifiers(player);
        DragonModifiers.updateBodyModifiers(player);
    }

    public static void updateTypeModifiers(Player player) {
        if (DragonStateProvider.getCap((Entity)player).isPresent()) {
            DragonStateHandler handler = DragonStateProvider.getHandler((Entity)player);
            if (handler.isDragon()) {
                AttributeModifier swimSpeed = DragonModifiers.buildSwimSpeedMod(handler.getType());
                DragonModifiers.updateSwimSpeedModifier(player, swimSpeed);
            } else {
                AttributeModifier oldMod = DragonModifiers.getSwimSpeedModifier(player);
                if (oldMod != null) {
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()));
                    max.m_22130_(oldMod);
                }
            }
        }
    }

    public static void updateSizeModifiers(Player player) {
        if (DragonStateProvider.getCap((Entity)player).isPresent()) {
            DragonStateHandler handler = DragonStateProvider.getHandler((Entity)player);
            if (handler.isDragon()) {
                double size = handler.getSize();
                AttributeModifier health = DragonModifiers.buildHealthMod(size);
                DragonModifiers.updateHealthModifier(player, health);
                AttributeModifier damage = DragonModifiers.buildDamageMod(handler, handler.isDragon());
                DragonModifiers.updateDamageModifier(player, damage);
                AttributeModifier reach = DragonModifiers.buildReachMod(size);
                DragonModifiers.updateReachModifier(player, reach);
                AttributeModifier stepHeight = DragonModifiers.buildStepHeightMod(handler, size);
                DragonModifiers.updateStepHeightModifier(player, stepHeight);
                AttributeModifier moveSpeed = DragonModifiers.buildMovementSpeedMod(handler, size);
                DragonModifiers.updateMovementSpeedModifier(player, moveSpeed);
            } else {
                AttributeModifier oldMod = DragonModifiers.getHealthModifier(player);
                if (oldMod != null) {
                    float oldMax = player.m_21233_();
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_(Attributes.f_22276_));
                    max.m_22130_(oldMod);
                    float newHealth = player.m_21223_() * player.m_21233_() / oldMax;
                    player.m_21153_(newHealth);
                }
                if ((oldMod = DragonModifiers.getDamageModifier(player)) != null) {
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_(Attributes.f_22281_));
                    max.m_22130_(oldMod);
                }
                if ((oldMod = DragonModifiers.getBlockReachModifier(player)) != null) {
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()));
                    max.m_22130_(oldMod);
                }
                if ((oldMod = DragonModifiers.getEntityReachModifier(player)) != null) {
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()));
                    max.m_22130_(oldMod);
                }
                if ((oldMod = DragonModifiers.getStepHeightModifier(player)) != null) {
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()));
                    max.m_22130_(oldMod);
                }
                if ((oldMod = DragonModifiers.getMovementSpeedModifier(player)) != null) {
                    AttributeInstance max = Objects.requireNonNull(player.m_21051_(Attributes.f_22279_));
                    max.m_22130_(oldMod);
                }
            }
        }
    }

    public static void updateBodyModifiers(Player player) {
        AbstractDragonBody body = DragonUtils.getDragonBody((Entity)player);
        boolean isDragon = DragonUtils.isDragon((Entity)player);
        AttributeInstance speedAttr = player.m_21051_(Attributes.f_22279_);
        AttributeInstance armorAttr = player.m_21051_(Attributes.f_22284_);
        AttributeInstance strengthAttr = player.m_21051_(Attributes.f_22281_);
        AttributeInstance attackKnockbackAttr = player.m_21051_(Attributes.f_22282_);
        AttributeInstance swimSpeedAttr = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
        AttributeInstance stepAttr = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        AttributeInstance gravityAttr = player.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        AttributeInstance healthAttr = player.m_21051_(Attributes.f_22276_);
        if (body != null && isDragon) {
            if (speedAttr.m_22111_(DRAGON_BODY_MOVEMENT_SPEED) == null || speedAttr.m_22111_(DRAGON_BODY_MOVEMENT_SPEED).m_22218_() != body.getRunMult().doubleValue()) {
                if (speedAttr.m_22111_(DRAGON_BODY_MOVEMENT_SPEED) != null) {
                    speedAttr.m_22120_(DRAGON_BODY_MOVEMENT_SPEED);
                }
                speedAttr.m_22118_(new AttributeModifier(DRAGON_BODY_MOVEMENT_SPEED, "BODY_MOVE_SPEED_BONUS", body.getRunMult() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (armorAttr.m_22111_(DRAGON_BODY_ARMOR) == null || armorAttr.m_22111_(DRAGON_BODY_ARMOR).m_22218_() != body.getArmorBonus().doubleValue()) {
                if (armorAttr.m_22111_(DRAGON_BODY_ARMOR) != null) {
                    armorAttr.m_22120_(DRAGON_BODY_ARMOR);
                }
                armorAttr.m_22118_(new AttributeModifier(DRAGON_BODY_ARMOR, "BODY_ARMOR_BONUS", body.getArmorBonus().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (strengthAttr.m_22111_(DRAGON_BODY_STRENGTH) == null || strengthAttr.m_22111_(DRAGON_BODY_STRENGTH).m_22218_() != body.getDamageBonus().doubleValue()) {
                if (strengthAttr.m_22111_(DRAGON_BODY_STRENGTH) != null) {
                    strengthAttr.m_22120_(DRAGON_BODY_STRENGTH);
                }
                strengthAttr.m_22118_(new AttributeModifier(DRAGON_BODY_STRENGTH, "BODY_STRENGTH_BONUS", body.getDamageBonus().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (strengthAttr.m_22111_(DRAGON_BODY_STRENGTH_MULT) == null || strengthAttr.m_22111_(DRAGON_BODY_STRENGTH_MULT).m_22218_() != body.getDamageMult() - 1.0) {
                if (strengthAttr.m_22111_(DRAGON_BODY_STRENGTH_MULT) != null) {
                    strengthAttr.m_22120_(DRAGON_BODY_STRENGTH_MULT);
                }
                strengthAttr.m_22118_(new AttributeModifier(DRAGON_BODY_STRENGTH_MULT, "BODY_STRENGTH_MULT", body.getDamageMult() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (attackKnockbackAttr.m_22111_(DRAGON_BODY_KNOCKBACK_BONUS) == null || attackKnockbackAttr.m_22111_(DRAGON_BODY_KNOCKBACK_BONUS).m_22218_() != body.getKnockbackBonus().doubleValue()) {
                if (attackKnockbackAttr.m_22111_(DRAGON_BODY_KNOCKBACK_BONUS) != null) {
                    attackKnockbackAttr.m_22120_(DRAGON_BODY_KNOCKBACK_BONUS);
                }
                attackKnockbackAttr.m_22118_(new AttributeModifier(DRAGON_BODY_KNOCKBACK_BONUS, "BODY_KNOCKBACK_BONUS", body.getKnockbackBonus().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (swimSpeedAttr.m_22111_(DRAGON_BODY_SWIM_SPEED_BONUS) == null || swimSpeedAttr.m_22111_(DRAGON_BODY_SWIM_SPEED_BONUS).m_22218_() != body.getSwimSpeedBonus().doubleValue()) {
                if (swimSpeedAttr.m_22111_(DRAGON_BODY_SWIM_SPEED_BONUS) != null) {
                    swimSpeedAttr.m_22120_(DRAGON_BODY_SWIM_SPEED_BONUS);
                }
                swimSpeedAttr.m_22118_(new AttributeModifier(DRAGON_BODY_SWIM_SPEED_BONUS, "BODY_SWIM_SPEED_BONUS", body.getSwimSpeedBonus().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (stepAttr.m_22111_(DRAGON_BODY_STEP_HEIGHT_BONUS) == null || stepAttr.m_22111_(DRAGON_BODY_STEP_HEIGHT_BONUS).m_22218_() != body.getStepBonus().doubleValue()) {
                if (stepAttr.m_22111_(DRAGON_BODY_STEP_HEIGHT_BONUS) != null) {
                    stepAttr.m_22120_(DRAGON_BODY_STEP_HEIGHT_BONUS);
                }
                stepAttr.m_22118_(new AttributeModifier(DRAGON_BODY_STEP_HEIGHT_BONUS, "BODY_STEP_HEIGHT_BONUS", body.getStepBonus().doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            if (gravityAttr.m_22111_(DRAGON_BODY_GRAVITY_MULT) == null || gravityAttr.m_22111_(DRAGON_BODY_GRAVITY_MULT).m_22218_() != body.getGravityMult() - 1.0) {
                if (gravityAttr.m_22111_(DRAGON_BODY_GRAVITY_MULT) != null) {
                    gravityAttr.m_22120_(DRAGON_BODY_GRAVITY_MULT);
                }
                gravityAttr.m_22118_(new AttributeModifier(DRAGON_BODY_GRAVITY_MULT, "BODY_GRAVITY_MULT", body.getGravityMult() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (healthAttr.m_22111_(DRAGON_BODY_HEALTH_MULT) == null || healthAttr.m_22111_(DRAGON_BODY_HEALTH_MULT).m_22218_() != body.getHealthMult() - 1.0) {
                if (healthAttr.m_22111_(DRAGON_BODY_HEALTH_MULT) != null) {
                    healthAttr.m_22120_(DRAGON_BODY_HEALTH_MULT);
                }
                healthAttr.m_22118_(new AttributeModifier(DRAGON_BODY_HEALTH_MULT, "BODY_HEALTH_MULT", body.getHealthMult() - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        } else {
            speedAttr.m_22120_(DRAGON_BODY_MOVEMENT_SPEED);
            armorAttr.m_22120_(DRAGON_BODY_ARMOR);
            strengthAttr.m_22120_(DRAGON_BODY_STRENGTH);
            strengthAttr.m_22120_(DRAGON_BODY_STRENGTH_MULT);
            attackKnockbackAttr.m_22120_(DRAGON_BODY_KNOCKBACK_BONUS);
            swimSpeedAttr.m_22120_(DRAGON_BODY_SWIM_SPEED_BONUS);
            stepAttr.m_22120_(DRAGON_BODY_STEP_HEIGHT_BONUS);
            gravityAttr.m_22120_(DRAGON_BODY_GRAVITY_MULT);
            healthAttr.m_22120_(DRAGON_BODY_HEALTH_MULT);
        }
    }

    @Nullable
    public static AttributeModifier getBlockReachModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get())).m_22111_(DRAGON_REACH_MODIFIER);
    }

    @Nullable
    public static AttributeModifier getEntityReachModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get())).m_22111_(DRAGON_REACH_MODIFIER);
    }

    @Nullable
    public static AttributeModifier getHealthModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_(Attributes.f_22276_)).m_22111_(DRAGON_HEALTH_MODIFIER);
    }

    @Nullable
    public static AttributeModifier getDamageModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_(Attributes.f_22281_)).m_22111_(DRAGON_DAMAGE_MODIFIER);
    }

    @Nullable
    public static AttributeModifier getSwimSpeedModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get())).m_22111_(DRAGON_SWIM_SPEED_MODIFIER);
    }

    @Nullable
    public static AttributeModifier getStepHeightModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())).m_22111_(DRAGON_STEP_HEIGHT_MODIFIER);
    }

    @Nullable
    public static AttributeModifier getMovementSpeedModifier(Player player) {
        return Objects.requireNonNull(player.m_21051_(Attributes.f_22279_)).m_22111_(DRAGON_MOVEMENT_SPEED_MODIFIER);
    }

    public static void updateReachModifier(Player player, AttributeModifier mod) {
        if (!ServerConfig.bonuses.booleanValue()) {
            return;
        }
        AttributeInstance blockReach = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()));
        blockReach.m_22130_(mod);
        blockReach.m_22125_(mod);
        AttributeInstance entityReach = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get()));
        entityReach.m_22130_(mod);
        entityReach.m_22125_(mod);
    }

    public static void updateHealthModifier(Player player, AttributeModifier mod) {
        if (!ServerConfig.healthAdjustments.booleanValue()) {
            return;
        }
        float oldMax = player.m_21233_();
        AttributeInstance max = Objects.requireNonNull(player.m_21051_(Attributes.f_22276_));
        max.m_22130_(mod);
        max.m_22125_(mod);
        float newHealth = player.m_21223_() * player.m_21233_() / oldMax;
        player.m_21153_(newHealth);
    }

    public static void updateDamageModifier(Player player, AttributeModifier mod) {
        if (!ServerConfig.bonuses.booleanValue() || !ServerConfig.attackDamage.booleanValue()) {
            return;
        }
        AttributeInstance max = Objects.requireNonNull(player.m_21051_(Attributes.f_22281_));
        max.m_22130_(mod);
        max.m_22125_(mod);
    }

    public static void updateSwimSpeedModifier(Player player, AttributeModifier mod) {
        if (!ServerConfig.bonuses.booleanValue() || !ServerConfig.seaSwimmingBonuses.booleanValue()) {
            return;
        }
        AttributeInstance max = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()));
        max.m_22130_(mod);
        max.m_22125_(mod);
    }

    public static void updateStepHeightModifier(Player player, AttributeModifier mod) {
        if (!ServerConfig.bonuses.booleanValue()) {
            return;
        }
        AttributeInstance max = Objects.requireNonNull(player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()));
        max.m_22130_(mod);
        max.m_22125_(mod);
    }

    public static void updateMovementSpeedModifier(Player player, AttributeModifier mod) {
        if (!ServerConfig.bonuses.booleanValue()) {
            return;
        }
        AttributeInstance max = Objects.requireNonNull(player.m_21051_(Attributes.f_22279_));
        max.m_22130_(mod);
        max.m_22125_(mod);
    }

    public static double getJumpBonus(DragonStateHandler handler) {
        double jumpBonus = 0.0;
        if (handler.getBody() != null) {
            jumpBonus = handler.getBody().getJumpBonus();
            if (ServerConfig.allowLargeScaling.booleanValue() && handler.getSize() > ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
                jumpBonus += ServerConfig.largeJumpHeightScalar * (handler.getSize() - ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / ServerConfig.DEFAULT_MAX_GROWTH_SIZE;
            }
        }
        switch (handler.getLevel()) {
            case NEWBORN: {
                jumpBonus += ServerConfig.newbornJump.doubleValue();
                break;
            }
            case YOUNG: {
                jumpBonus += ServerConfig.youngJump.doubleValue();
                break;
            }
            case ADULT: {
                jumpBonus += ServerConfig.adultJump.doubleValue();
            }
        }
        return jumpBonus;
    }
}

