/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.containers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.ClawInventory;
import by.dragonsurvivalteam.dragonsurvival.registry.DSContainers;
import by.dragonsurvivalteam.dragonsurvival.server.containers.slots.ClawToolSlot;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class DragonContainer
extends AbstractContainerMenu {
    public final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    public final ResultContainer craftResult = new ResultContainer();
    public final Player player;
    public List<Slot> craftingSlots = new ArrayList<Slot>();
    public List<Slot> inventorySlots = new ArrayList<Slot>();
    public Inventory playerInventory;
    public int menuStatus;
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_};
    private final int craftingResultIndex;
    protected final ContainerData dataStatus = new ContainerData(){

        public int m_6413_(int index) {
            if (index == 0) {
                return DragonContainer.this.menuStatus;
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            if (index == 0) {
                DragonContainer.this.menuStatus = value;
            }
        }

        public int m_6499_() {
            return 1;
        }
    };

    public DragonContainer(int id, Inventory inventory) {
        super(DSContainers.dragonContainer, id);
        Slot s;
        int i;
        this.player = inventory.f_35978_;
        this.playerInventory = inventory;
        this.m_38884_(this.dataStatus);
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot equipmentSlot = VALID_EQUIPMENT_SLOTS[i];
            this.m_38897_(new Slot((Container)inventory, 39 - i, 8, 8 + i * 18){

                public boolean m_5857_(@NotNull ItemStack itemStack) {
                    return itemStack.canEquip(equipmentSlot, (Entity)DragonContainer.this.player);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)ARMOR_SLOT_TEXTURES[equipmentSlot.m_20749_()]);
                }

                public boolean m_8010_(@NotNull Player player) {
                    ItemStack itemStack = this.m_7993_();
                    return (itemStack.m_41619_() || player.m_7500_() || !EnchantmentHelper.m_44920_((ItemStack)itemStack)) && super.m_8010_(player);
                }
            });
            this.m_38946_();
        }
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 9; ++row) {
                s = new Slot((Container)inventory, row + column * 9 + 9, 8 + row * 18, 84 + column * 18);
                this.m_38897_(s);
                this.inventorySlots.add(s);
            }
        }
        for (i = 0; i < 9; ++i) {
            Slot s2 = new Slot((Container)inventory, i, 8 + i * 18, 142);
            this.m_38897_(s2);
            this.inventorySlots.add(s2);
        }
        DragonStateProvider.getCap((Entity)this.player).ifPresent(handler -> {
            for (int i = 0; i < ClawInventory.Slot.size(); ++i) {
                ClawToolSlot clawToolSlot = new ClawToolSlot(this, (Container)handler.getClawToolData().getClawsInventory(), i, -50, 35 + i * 18, i);
                this.m_38897_(clawToolSlot);
                this.inventorySlots.add(clawToolSlot);
            }
        });
        this.m_38897_(new Slot((Container)inventory, 40, 26, 62));
        this.m_38897_((Slot)new ResultSlot(inventory.f_35978_, this.craftMatrix, (Container)this.craftResult, 0, 178, 33));
        this.craftingResultIndex = this.f_38839_.size() - 1;
        for (int row = 0; row < this.craftMatrix.m_39347_(); ++row) {
            for (int column = 0; column < this.craftMatrix.m_39346_(); ++column) {
                s = new Slot((Container)this.craftMatrix, column + row * 3, 111 + column * 18, 15 + row * 18);
                this.m_38897_(s);
                this.craftingSlots.add(s);
            }
        }
        this.update();
    }

    public void update() {
        DragonStateProvider.getCap((Entity)this.player).ifPresent(handler -> {
            this.menuStatus = handler.getClawToolData().isMenuOpen() ? 1 : 0;
        });
        this.m_38946_();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            int i;
            ItemStack slotItemStack = slot.m_7993_();
            itemStack = slotItemStack.m_41777_();
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
            if (index == this.craftingResultIndex) {
                if (this.menuStatus == 1 ? !this.m_38903_(slotItemStack, 4, 44, true) : !this.m_38903_(slotItemStack, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItemStack, itemStack);
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(3 - equipmentSlot.m_20749_())).m_6657_() ? !this.m_38903_(slotItemStack, i = 3 - equipmentSlot.m_20749_(), i + 1, false) : (index < 4 ? !this.m_38903_(slotItemStack, 4, 40, false) : (this.menuStatus == 1 && !((Slot)this.f_38839_.get(42)).m_6657_() && ToolUtils.isAxe(slotItemStack) ? !this.m_38903_(slotItemStack, 42, 43, false) : (this.menuStatus == 1 && !((Slot)this.f_38839_.get(40)).m_6657_() && ToolUtils.isWeapon(slotItemStack) ? !this.m_38903_(slotItemStack, 40, 41, false) : (this.menuStatus == 1 && !((Slot)this.f_38839_.get(41)).m_6657_() && ToolUtils.isPickaxe(slotItemStack) ? !this.m_38903_(slotItemStack, 41, 42, false) : (this.menuStatus == 1 && !((Slot)this.f_38839_.get(43)).m_6657_() && ToolUtils.isShovel(slotItemStack) ? !this.m_38903_(slotItemStack, 43, 44, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(44)).m_6657_() ? !this.m_38903_(slotItemStack, 44, 45, false) : (index < 31 ? !this.m_38903_(slotItemStack, 31, 40, false) : (index < 40 ? !this.m_38903_(slotItemStack, 4, 31, false) : !this.m_38903_(slotItemStack, 4, 31, false)))))))))) {
                return ItemStack.f_41583_;
            }
            if (slotItemStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItemStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slotItemStack);
            if (index == 0) {
                player.m_36176_(slotItemStack, false);
            }
        }
        return itemStack;
    }

    public boolean m_5882_(@Nonnull ItemStack itemStack, Slot slot) {
        return slot.f_40218_ != this.craftResult && super.m_5882_(itemStack, slot);
    }

    public void m_6877_(@NotNull Player player) {
        super.m_6877_(player);
        this.m_150411_(player, (Container)this.craftMatrix);
    }

    public void m_6199_(@NotNull Container inventory) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = ItemStack.f_41583_;
            Optional recipeOptional = serverPlayer.m_9236_().m_7654_().m_129894_().m_44015_(RecipeType.f_44107_, (Container)this.craftMatrix, serverPlayer.m_9236_());
            if (recipeOptional.isPresent()) {
                CraftingRecipe recipe = (CraftingRecipe)recipeOptional.get();
                if (this.craftResult.m_40135_(this.player.m_9236_(), serverPlayer, (Recipe)recipe)) {
                    itemStack = recipe.m_5874_((Container)this.craftMatrix, serverPlayer.m_9236_().m_9598_());
                }
            }
            this.craftResult.m_6836_(45, itemStack);
            this.m_150404_(45, itemStack);
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.f_38840_, this.m_182425_(), 45, itemStack));
        }
    }

    public boolean m_6875_(@NotNull Player ignored) {
        return true;
    }
}

