/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.containers.slots;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.subcapabilities.ClawInventory;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.claw.SyncDragonClawsMenu;
import by.dragonsurvivalteam.dragonsurvival.server.containers.DragonContainer;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.ToolUtils;
import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class ClawToolSlot
extends Slot {
    static final ResourceLocation AXE_TEXTURE = new ResourceLocation("dragonsurvival", "gui/dragon_claws_axe");
    static final ResourceLocation PICKAXE_TEXTURE = new ResourceLocation("dragonsurvival", "gui/dragon_claws_pickaxe");
    static final ResourceLocation SHOVEL_TEXTURE = new ResourceLocation("dragonsurvival", "gui/dragon_claws_shovel");
    static final ResourceLocation SWORD_TEXTURE = new ResourceLocation("dragonsurvival", "gui/dragon_claws_sword");
    private final DragonContainer dragonContainer;
    private final int clawSlot;

    public ClawToolSlot(DragonContainer dragonContainer, Container container, int index, int x, int y, int clawSlot) {
        super(container, index, x, y);
        this.dragonContainer = dragonContainer;
        this.clawSlot = clawSlot;
    }

    public boolean m_5857_(@NotNull ItemStack itemStack) {
        return switch (ClawInventory.Slot.values()[this.clawSlot]) {
            default -> throw new IncompatibleClassChangeError();
            case ClawInventory.Slot.SWORD -> ToolUtils.isWeapon(itemStack);
            case ClawInventory.Slot.PICKAXE -> ToolUtils.isPickaxe(itemStack);
            case ClawInventory.Slot.AXE -> ToolUtils.isAxe(itemStack);
            case ClawInventory.Slot.SHOVEL -> ToolUtils.isShovel(itemStack);
        };
    }

    public void m_5852_(@NotNull ItemStack itemStack) {
        super.m_5852_(itemStack);
        this.syncSlots();
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> m_7543_() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)(this.clawSlot == 0 ? SWORD_TEXTURE : (this.clawSlot == 2 ? AXE_TEXTURE : (this.clawSlot == 1 ? PICKAXE_TEXTURE : SHOVEL_TEXTURE))));
    }

    @NotNull
    public ItemStack m_6201_(int amount) {
        ItemStack stack = super.m_6201_(amount);
        this.syncSlots();
        return stack;
    }

    public boolean m_6659_() {
        return this.dragonContainer.menuStatus == 1;
    }

    private void syncSlots() {
        if (!this.dragonContainer.player.m_9236_().m_5776_()) {
            DragonStateHandler handler = DragonUtils.getHandler((Entity)this.dragonContainer.player);
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.dragonContainer.player), (Object)new SyncDragonClawsMenu(this.dragonContainer.player.m_19879_(), handler.getClawToolData().isMenuOpen(), handler.getClawToolData().getClawsInventory()));
        }
    }
}

