/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.DragonSizeHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DragonDestructionHandler {
    private static int crushTickCounter = 0;
    private static boolean isBreakingMultipleBlocks = false;

    private static void checkAndDestroyCollidingBlocks(DragonStateHandler dragonStateHandler, TickEvent.PlayerTickEvent event, AABB boundingBox) {
        if (!ServerConfig.allowLargeBlockDestruction.booleanValue()) {
            return;
        }
        if (ServerConfig.largeBlockDestructionSize > dragonStateHandler.getSize()) {
            return;
        }
        int i = Mth.m_14107_((double)boundingBox.f_82288_);
        int j = Mth.m_14107_((double)boundingBox.f_82289_);
        int k = Mth.m_14107_((double)boundingBox.f_82290_);
        int l = Mth.m_14165_((double)boundingBox.f_82291_);
        int i1 = Mth.m_14165_((double)boundingBox.f_82292_);
        int j1 = Mth.m_14165_((double)boundingBox.f_82293_);
        XoroshiroRandomSource random = new XoroshiroRandomSource(event.player.m_9236_().m_46467_());
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    BlockPos blockpos = new BlockPos(k1, l1, i2);
                    BlockState blockstate = event.player.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_()) continue;
                    if (ServerConfig.useBlacklistForDestructibleBlocks.booleanValue()) {
                        if (DragonConfigHandler.DRAGON_DESTRUCTIBLE_BLOCKS.contains(blockstate.m_60734_())) continue;
                        if ((double)random.m_188501_() > ServerConfig.largeBlockDestructionRemovePercentage) {
                            event.player.m_9236_().m_46961_(blockpos, false);
                            continue;
                        }
                        event.player.m_9236_().m_7471_(blockpos, false);
                        continue;
                    }
                    if (!DragonConfigHandler.DRAGON_DESTRUCTIBLE_BLOCKS.contains(blockstate.m_60734_()) && !blockstate.m_247087_() && !blockstate.m_204336_(BlockTags.f_144280_) && !blockstate.m_204336_(BlockTags.f_13041_)) continue;
                    if ((double)random.m_188501_() > ServerConfig.largeBlockDestructionRemovePercentage) {
                        event.player.m_9236_().m_46961_(blockpos, false);
                        continue;
                    }
                    event.player.m_9236_().m_7471_(blockpos, false);
                }
            }
        }
    }

    private static void checkAndDamageCrushedEntities(DragonStateHandler dragonStateHandler, ServerPlayer player, AABB boundingBox) {
        if (!ServerConfig.allowCrushing.booleanValue()) {
            return;
        }
        if (ServerConfig.crushingSize > dragonStateHandler.getSize()) {
            return;
        }
        if (--crushTickCounter > 0) {
            return;
        }
        AABB feetBoundingBox = new AABB(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_, boundingBox.f_82291_, boundingBox.f_82292_ - (boundingBox.f_82292_ - boundingBox.f_82289_) / 3.0, boundingBox.f_82293_);
        for (LivingEntity entity : player.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)player, feetBoundingBox)) {
            if (entity.m_20191_().m_82309_() > boundingBox.m_82309_() / 2.0) continue;
            entity.m_6469_(DSDamageTypes.entityDamageSource(player.m_9236_(), DSDamageTypes.CRUSHED, (Entity)player), (float)(dragonStateHandler.getSize() * ServerConfig.crushingDamageScalar));
            crushTickCounter = ServerConfig.crushingTickDelay;
        }
    }

    @SubscribeEvent
    public static void destroyBlocksInRadius(BlockEvent.BreakEvent event) {
        if (isBreakingMultipleBlocks) {
            return;
        }
        if (!ServerConfig.allowLargeScaling.booleanValue()) {
            return;
        }
        if (ServerConfig.largeBlockBreakRadiusScalar <= 0.0) {
            return;
        }
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (player2.m_6047_()) {
            return;
        }
        DragonStateProvider.getCap((Entity)player2).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                if (dragonStateHandler.getSize() < ServerConfig.DEFAULT_MAX_GROWTH_SIZE) {
                    return;
                }
                isBreakingMultipleBlocks = true;
                event.setCanceled(true);
                int radius = (int)Math.floor((dragonStateHandler.getSize() - ServerConfig.DEFAULT_MAX_GROWTH_SIZE) / 60.0 * ServerConfig.largeBlockBreakRadiusScalar);
                BlockPos pos = event.getPos();
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            BlockPos newPos = pos.m_7918_(x, y, z);
                            player.f_8941_.m_9280_(newPos);
                        }
                    }
                }
                isBreakingMultipleBlocks = false;
            }
        });
    }

    @SubscribeEvent
    public static void checkAndDestroyCollidingBlocksAndCrushedEntities(TickEvent.PlayerTickEvent event) {
        if (!ServerConfig.allowLargeBlockDestruction.booleanValue() && !ServerConfig.allowCrushing.booleanValue()) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        DragonStateProvider.getCap((Entity)player2).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                AABB boundingBox;
                if (player2.m_6047_()) {
                    return;
                }
                Vec2 deltaXZ = new Vec2((float)player.m_20184_().f_82479_, (float)player.m_20184_().f_82481_);
                if (deltaXZ.m_165907_() < 0.05f && Math.abs(player.m_20184_().f_82480_) < 0.25) {
                    return;
                }
                if (ServerConfig.sizeChangesHitbox.booleanValue()) {
                    boolean squish = dragonStateHandler.getBody() == null ? dragonStateHandler.getBody().isSquish() : false;
                    double size = dragonStateHandler.getSize();
                    double height = DragonSizeHandler.calculateModifiedHeight(DragonSizeHandler.calculateDragonHeight(size, ServerConfig.hitboxGrowsPastHuman), event.player.m_20089_(), ServerConfig.sizeChangesHitbox, squish);
                    double width = DragonSizeHandler.calculateDragonWidth(size, ServerConfig.hitboxGrowsPastHuman) / 2.0;
                    boundingBox = DragonSizeHandler.calculateDimensions(width, height).m_20393_(player2.m_20182_());
                } else {
                    boundingBox = player2.m_20191_();
                }
                boundingBox = boundingBox.m_82400_(1.25);
                DragonDestructionHandler.checkAndDestroyCollidingBlocks(dragonStateHandler, event, boundingBox);
                DragonDestructionHandler.checkAndDamageCrushedEntities(dragonStateHandler, player2, boundingBox);
            }
        });
    }
}

