/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.player.SynchronizeDragonCap;
import by.dragonsurvivalteam.dragonsurvival.network.status.RefreshDragons;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.ResourceHelper;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class DragonRidingHandler {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity ent = event.getTarget();
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (ent instanceof ServerPlayer) {
            ServerPlayer target = (ServerPlayer)ent;
            Player self = event.getEntity();
            DragonStateProvider.getCap((Entity)target).ifPresent(targetCap -> {
                if (targetCap.isDragon() && target.m_20089_() == Pose.CROUCHING && targetCap.getSize() >= 40.0 && !target.m_20160_()) {
                    DragonStateProvider.getCap((Entity)self).ifPresent(selfCap -> {
                        if (!selfCap.isDragon() || selfCap.getLevel() == DragonLevel.NEWBORN) {
                            self.m_20329_((Entity)target);
                            target.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)target));
                            targetCap.setPassengerId(self.m_19879_());
                            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)new SynchronizeDragonCap(target.m_19879_(), targetCap.isHiding(), targetCap.getType(), targetCap.getBody(), targetCap.getSize(), targetCap.hasFlight(), self.m_19879_()));
                            event.setCancellationResult(InteractionResult.SUCCESS);
                            event.setCanceled(true);
                        }
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public static void handleMounts(EntityMountEvent event) {
        if (!event.isMounting()) {
            return;
        }
        if (ServerConfig.ridingBlacklist.booleanValue() && DragonUtils.isDragon(event.getEntityMounting())) {
            if (DragonUtils.isDragon(event.getEntityBeingMounted())) {
                return;
            }
            if (!ServerConfig.allowedVehicles.contains(ResourceHelper.getKey(event.getEntityBeingMounted()).toString())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onServerPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        DragonStateProvider.getCap((Entity)player2).ifPresent(handler -> {
            Entity passenger = player2.m_9236_().m_6815_(handler.getPassengerId());
            boolean stopRiding = false;
            if (!(passenger instanceof ServerPlayer)) {
                return;
            }
            if (!handler.isDragon()) {
                stopRiding = true;
            } else if (player2.m_5833_()) {
                stopRiding = true;
            } else if (handler.isDragon() && handler.getSize() < 40.0) {
                stopRiding = true;
            } else if (player2.m_5803_()) {
                stopRiding = true;
            }
            if (!stopRiding) {
                DragonStateHandler passengerHandler = DragonUtils.getHandler(passenger);
                if (passengerHandler.isDragon() && passengerHandler.getLevel() != DragonLevel.NEWBORN) {
                    stopRiding = true;
                } else if (passenger.m_20201_() != player2.m_20201_()) {
                    stopRiding = true;
                } else if (passenger.m_5833_()) {
                    stopRiding = true;
                }
            }
            if (stopRiding) {
                passenger.m_8127_();
                player.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)player2));
            }
            if (stopRiding || !player2.m_20363_(passenger)) {
                handler.setPassengerId(-1);
                NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SynchronizeDragonCap(player2.m_19879_(), handler.isHiding(), handler.getType(), handler.getBody(), handler.getSize(), handler.hasFlight(), 0));
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        Entity entity;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_20202_() == null || !((entity = player.m_20202_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer vehicle = (ServerPlayer)entity;
        DragonStateProvider.getCap((Entity)player).ifPresent(playerCap -> DragonStateProvider.getCap((Entity)vehicle).ifPresent(vehicleCap -> {
            player.m_8127_();
            vehicle.f_8906_.m_9829_((Packet)new ClientboundSetPassengersPacket((Entity)vehicle));
            vehicleCap.setPassengerId(-1);
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> vehicle), (Object)new SynchronizeDragonCap(player.m_19879_(), vehicleCap.isHiding(), vehicleCap.getType(), vehicleCap.getBody(), vehicleCap.getSize(), vehicleCap.hasFlight(), 0));
        }));
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent changedDimensionEvent) {
        Player player = changedDimensionEvent.getEntity();
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SynchronizeDragonCap(player.m_19879_(), dragonStateHandler.isHiding(), dragonStateHandler.getType(), dragonStateHandler.getBody(), dragonStateHandler.getSize(), dragonStateHandler.hasFlight(), 0));
            NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new RefreshDragons(player.m_19879_()));
        });
    }
}

