/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.handlers;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.DragonTypes;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigOption;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigRange;
import by.dragonsurvivalteam.dragonsurvival.config.obj.ConfigSide;
import by.dragonsurvivalteam.dragonsurvival.network.NetworkHandler;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncFlyingStatus;
import by.dragonsurvivalteam.dragonsurvival.network.flight.SyncSpinStatus;
import by.dragonsurvivalteam.dragonsurvival.registry.DragonEffects;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ServerFlightHandler {
    public static final int spinDuration = (int)Math.round(15.2);
    @ConfigRange(min=0.1, max=1.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="maxFlightSpeed", comment={"Maximum acceleration fly speed up and down. Take into account the chunk load speed. A speed of 0.3 is optimal."})
    public static Double maxFlightSpeed = 0.3;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="startWithLevitation", comment={"Whether dragons can use levitation magic from birth."})
    public static Boolean startWithLevitation = true;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="enderDragonGrantsSpin", comment={"Whether you should be able to obtain the spin ability from the ender dragon or take special item."})
    public static Boolean enderDragonGrantsSpin = true;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="allowFlyingWhenTotallyHungry", comment={"Whether dragons can fly when totally hungry. You can't open your wings if you're hungry."})
    public static Boolean allowFlyingWithoutHunger = false;
    @ConfigRange(min=0.0, max=20.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flightHungerThreshold", comment={"If the player's hunger is below this parameter, he can't open his wings."})
    public static Integer flightHungerThreshold = 6;
    @ConfigRange(min=0.0, max=20.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flightHungerThreshold", comment={"If the player's hunger is less then or equal to this parameter, the wings will be folded even during flight."})
    public static Integer foldWingsThreshold = 0;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flyingUsesHunger", comment={"Whether you use up hunger while flying."})
    public static Boolean flyingUsesHunger = true;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="enableFlightFallDamage", comment={"Whether fall damage in flight is included. If true dragon will take damage from the fall."})
    public static Boolean enableFlightFallDamage = true;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="lethalFallDamage", comment={"Whether fall damage from flight is lethal, otherwise it will leave you at half a heart"})
    public static Boolean lethalFlight = false;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="foldWingsOnLand", comment={"Whether your wings will fold automatically when landing. Has protection against accidental triggering, so the wings do not always close. If False you must close the wings manually."})
    public static Boolean foldWingsOnLand = false;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="alternateFlight", comment={"Whether to use flight similar to creative rather then gliding."})
    public static Boolean creativeFlight = false;
    @ConfigRange(min=0.0, max=100000.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="flightSpinCooldown", comment={"The cooldown in seconds in between uses of the spin attack in flight"})
    public static Integer flightSpinCooldown = 5;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="stableHover", comment={"Should hovering be completely stable similar to creative flight?"})
    public static boolean stableHover = false;
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="unlimitedFlightAcceleration", comment={"Old flight physics with infinite acceleration (bug). Can cause server lags and feel too fast."})
    public static Boolean unlimitedFlightAcceleration = false;
    @ConfigRange(min=0.0, max=60.0)
    @ConfigOption(side=ConfigSide.SERVER, category={"wings"}, key="levitationAfterEffect", comment={"For how many seconds wings are disabled after the levitation effect has ended"})
    public static Integer levitationAfterEffect = 3;
    @ConfigRange(min=1.0, max=72000.0)
    @ConfigOption(side=ConfigSide.SERVER, key="flightHungerTicks", category={"wings"}, comment={"How many ticks it takes for one hunger point to be drained while flying, this is based on hover flight."})
    public static int flightHungerTicks = 50;

    @SubscribeEvent
    public static void changeFallDistance(LivingFallEvent event) {
        LivingEntity livingEntity = event.getEntity();
        double flightSpeed = event.getDistance();
        DragonStateProvider.getCap((Entity)livingEntity).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon() && dragonStateHandler.hasFlight()) {
                try {
                    if (!enableFlightFallDamage.booleanValue()) {
                        event.setCanceled(true);
                        return;
                    }
                    if (flightSpeed <= 2.0 || dragonStateHandler.isWingsSpread() && !livingEntity.m_20142_() && flightSpeed <= 4.0) {
                        event.setCanceled(true);
                        return;
                    }
                    if (livingEntity.m_20159_() && DragonUtils.isDragon(livingEntity.m_20202_())) {
                        event.setCanceled(true);
                        return;
                    }
                    MobEffectInstance effectinstance = livingEntity.m_21124_(MobEffects.f_19603_);
                    float f = effectinstance == null ? 0.0f : (float)(effectinstance.m_19564_() + 1);
                    double damage = livingEntity.m_20184_().m_82556_() * (dragonStateHandler.getSize() / 20.0);
                    damage = Mth.m_14008_((double)damage, (double)0.0, (double)(livingEntity.m_21223_() - (float)(lethalFlight == false ? 1 : 0)));
                    if (!livingEntity.m_9236_().m_5776_() && dragonStateHandler.isWingsSpread()) {
                        event.setDistance((float)Math.floor((damage + 3.0 + (double)f) * (double)event.getDamageMultiplier()));
                    }
                }
                finally {
                    if (!livingEntity.m_9236_().m_5776_() && foldWingsOnLand.booleanValue() && dragonStateHandler.isWingsSpread()) {
                        dragonStateHandler.setWingsSpread(false);
                        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SyncFlyingStatus(livingEntity.m_19879_(), false));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void foldWings(TickEvent.PlayerTickEvent tickEvent) {
        Player player = tickEvent.player;
        if (tickEvent.phase == TickEvent.Phase.START || player.m_9236_().m_5776_() || !DragonUtils.isDragon((Entity)player)) {
            return;
        }
        if (!foldWingsOnLand.booleanValue() || player.m_36324_().m_38702_() <= flightHungerThreshold && !player.m_7500_() && !allowFlyingWithoutHunger.booleanValue()) {
            return;
        }
        DragonStateHandler dragonStateHandler = DragonUtils.getHandler((Entity)player);
        if (dragonStateHandler.isWingsSpread()) {
            player.f_19789_ = Math.max(0.0f, player.f_19789_ * 0.5f);
        }
        if (dragonStateHandler.hasFlown && player.m_20096_()) {
            if (dragonStateHandler.isWingsSpread() && player.m_7500_()) {
                dragonStateHandler.hasFlown = false;
                dragonStateHandler.setWingsSpread(false);
                NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncFlyingStatus(player.m_19879_(), false));
            }
        } else if (!dragonStateHandler.hasFlown && ServerFlightHandler.isFlying((LivingEntity)player)) {
            dragonStateHandler.hasFlown = true;
        }
    }

    public static boolean isFlying(LivingEntity player) {
        DragonStateHandler dragonStateHandler = DragonUtils.getHandler((Entity)player);
        return dragonStateHandler.hasFlight() && dragonStateHandler.isWingsSpread() && !player.m_20096_() && !player.m_20069_() && !player.m_20077_();
    }

    @SubscribeEvent
    public static void playerFlightIcon(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            if (handler.isDragon() && player.f_19797_ % 10 == 0 && handler.isWingsSpread()) {
                if (DragonUtils.isDragonType((Entity)player, (AbstractDragonType)DragonTypes.SEA)) {
                    player.m_7292_(new MobEffectInstance(DragonEffects.sea_wings, 500));
                }
                if (DragonUtils.isDragonType((Entity)player, (AbstractDragonType)DragonTypes.CAVE)) {
                    player.m_7292_(new MobEffectInstance(DragonEffects.cave_wings, 500));
                }
                if (DragonUtils.isDragonType((Entity)player, (AbstractDragonType)DragonTypes.FOREST)) {
                    player.m_7292_(new MobEffectInstance(DragonEffects.forest_wings, 500));
                }
            }
            if (!handler.isDragon() || !handler.isWingsSpread()) {
                if (player.m_21023_(DragonEffects.sea_wings)) {
                    player.m_183634_();
                    player.m_21195_(DragonEffects.sea_wings);
                }
                if (player.m_21023_(DragonEffects.cave_wings)) {
                    player.m_183634_();
                    player.m_21195_(DragonEffects.cave_wings);
                }
                if (player.m_21023_(DragonEffects.forest_wings)) {
                    player.m_183634_();
                    player.m_21195_(DragonEffects.forest_wings);
                }
            }
        });
    }

    @SubscribeEvent
    public static void playerFlightAttacks(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(handler -> {
            if (handler.isDragon()) {
                if (!(handler.getMovementData().spinAttack <= 0 || ServerFlightHandler.isFlying((LivingEntity)player) || ServerFlightHandler.canSwimSpin((LivingEntity)player) || player.m_9236_().m_5776_())) {
                    handler.getMovementData().spinAttack = 0;
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSpinStatus(player.m_19879_(), handler.getMovementData().spinAttack, handler.getMovementData().spinCooldown, handler.getMovementData().spinLearned));
                }
                if (ServerFlightHandler.isSpin(player)) {
                    int range = 5;
                    List entities = player.m_9236_().m_45933_(null, new AABB(player.m_20182_().f_82479_ - (double)range, player.m_20182_().f_82480_ - (double)range, player.m_20182_().f_82481_ - (double)range, player.m_20182_().f_82479_ + (double)range, player.m_20182_().f_82480_ + (double)range, player.m_20182_().f_82481_ + (double)range));
                    entities.removeIf(e -> e.m_20270_((Entity)player) > (float)range);
                    entities.remove(player);
                    entities.removeIf(e -> e instanceof Player && !player.m_7099_((Player)e));
                    for (Entity ent : entities) {
                        LivingEntity entity;
                        if (player.m_20363_(ent) || ent instanceof LivingEntity && (entity = (LivingEntity)ent).m_21188_() == player && entity.m_21213_() <= entity.f_19797_ + 100) continue;
                        player.m_5706_(ent);
                    }
                    --handler.getMovementData().spinAttack;
                    if (!player.m_9236_().m_5776_()) {
                        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSpinStatus(player.m_19879_(), handler.getMovementData().spinAttack, handler.getMovementData().spinCooldown, handler.getMovementData().spinLearned));
                    }
                } else if (handler.getMovementData().spinCooldown > 0 && !player.m_9236_().m_5776_()) {
                    --handler.getMovementData().spinCooldown;
                    NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncSpinStatus(player.m_19879_(), handler.getMovementData().spinAttack, handler.getMovementData().spinCooldown, handler.getMovementData().spinLearned));
                }
            }
        });
    }

    public static boolean isSpin(Player entity) {
        DragonStateHandler handler = DragonUtils.getHandler((Entity)entity);
        if (ServerFlightHandler.isFlying((LivingEntity)entity) || ServerFlightHandler.canSwimSpin((LivingEntity)entity)) {
            return handler.getMovementData().spinAttack > 0;
        }
        return false;
    }

    public static boolean canSwimSpin(LivingEntity player) {
        DragonStateHandler dragonStateHandler = DragonUtils.getHandler((Entity)player);
        boolean validSwim = (Objects.equals(dragonStateHandler.getType(), DragonTypes.SEA) || Objects.equals(dragonStateHandler.getType(), DragonTypes.FOREST)) && player.m_20069_() || player.m_20077_() && Objects.equals(dragonStateHandler.getType(), DragonTypes.CAVE);
        return validSwim && dragonStateHandler.hasFlight() && !player.m_20096_();
    }

    @SubscribeEvent
    public static void playerFoodExhaustion(TickEvent.PlayerTickEvent playerTickEvent) {
        if (playerTickEvent.phase == TickEvent.Phase.START) {
            return;
        }
        Player player = playerTickEvent.player;
        DragonStateProvider.getCap((Entity)player).ifPresent(dragonStateHandler -> {
            if (dragonStateHandler.isDragon()) {
                boolean wingsSpread = dragonStateHandler.isWingsSpread();
                if (creativeFlight.booleanValue() && !player.m_9236_().m_5776_() && player.m_150110_().f_35935_ != wingsSpread && !player.m_7500_() && !player.m_5833_()) {
                    player.m_150110_().f_35935_ = wingsSpread;
                    player.m_6885_();
                }
                if (wingsSpread && flyingUsesHunger.booleanValue() && ServerFlightHandler.isFlying((LivingEntity)player)) {
                    if (!(player.m_9236_().m_5776_() || player.m_36324_().m_38702_() > foldWingsThreshold || allowFlyingWithoutHunger.booleanValue() || player.m_7500_())) {
                        player.m_213846_((Component)Component.m_237115_((String)"ds.wings.nohunger"));
                        dragonStateHandler.setWingsSpread(false);
                        NetworkHandler.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), (Object)new SyncFlyingStatus(player.m_19879_(), false));
                        return;
                    }
                    Vec3 delta = player.m_20184_();
                    float moveSpeed = (float)delta.m_165924_();
                    float l = 4.0f / (float)flightHungerTicks;
                    float moveSpeedReq = 1.0f;
                    float minFoodReq = l / 10.0f;
                    float drain = Math.max(minFoodReq, (float)(Math.min(1.0, (double)Math.max(0.0f, Math.max(moveSpeedReq - moveSpeed, 0.0f) / moveSpeedReq)) * (double)l));
                    if (dragonStateHandler.getBody() != null) {
                        drain = (float)((double)drain * dragonStateHandler.getBody().getFlightStaminaMult());
                    }
                    player.m_36399_(drain);
                }
            }
        });
    }

    public static boolean isGliding(Player player) {
        DragonStateHandler dragonStateHandler = DragonUtils.getHandler((Entity)player);
        boolean hasFood = player.m_36324_().m_38702_() > flightHungerThreshold || player.m_7500_() || allowFlyingWithoutHunger != false;
        return hasFood && player.m_20142_() && ServerFlightHandler.isFlying((LivingEntity)player);
    }

    public static double distanceFromGround(Player player) {
        BlockPos blockHeight = player.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, player.m_20183_());
        int height = blockHeight.m_123342_();
        double aboveGround = Math.max(0.0, player.m_20182_().f_82480_ - (double)height);
        return aboveGround;
    }
}

