/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.server.tileentity;

import by.dragonsurvivalteam.dragonsurvival.client.sounds.SoundRegistry;
import by.dragonsurvivalteam.dragonsurvival.common.blocks.DragonBeacon;
import by.dragonsurvivalteam.dragonsurvival.config.ConfigHandler;
import by.dragonsurvivalteam.dragonsurvival.config.ServerConfig;
import by.dragonsurvivalteam.dragonsurvival.registry.DSBlocks;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.BaseBlockTileEntity;
import by.dragonsurvivalteam.dragonsurvival.server.tileentity.DSTileEntities;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import by.dragonsurvivalteam.dragonsurvival.util.Functions;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DragonBeaconTileEntity
extends BaseBlockTileEntity {
    public Type type = Type.NONE;
    public float tick;
    public final float bobOffs;

    public DragonBeaconTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(DSTileEntities.dragonBeacon, pWorldPosition, pBlockState);
        DragonBeaconTileEntity.setType(this, pBlockState.m_60734_());
        this.bobOffs = new Random().nextFloat() * (float)Math.PI * 2.0f;
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, DragonBeaconTileEntity pBlockEntity) {
        BlockState below = pLevel.m_8055_(pPos.m_7495_());
        if (below.m_60734_() == DSBlocks.dragonMemoryBlock && pBlockEntity.type != Type.NONE) {
            if (!((Boolean)pState.m_61143_((Property)DragonBeacon.LIT)).booleanValue()) {
                pLevel.m_46597_(pPos, (BlockState)pState.m_61122_((Property)DragonBeacon.LIT));
                pLevel.m_5594_(null, pPos, SoundRegistry.activateBeacon, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!pLevel.m_5776_()) {
                List dragons = pLevel.m_6443_(Player.class, new AABB(pPos).m_82400_(50.0).m_82363_(0.0, (double)pLevel.m_151558_(), 0.0), DragonUtils::isDragon);
                switch (pBlockEntity.type) {
                    case PEACE: {
                        dragons.forEach(playerEntity -> ConfigHandler.getResourceElements(MobEffect.class, ServerConfig.peaceBeaconEffects).forEach(effect -> {
                            if (effect != null) {
                                playerEntity.m_7292_(new MobEffectInstance(effect, Functions.minutesToTicks(ServerConfig.minutesOfDragonEffect) + 5, 0, true, true));
                            }
                        }));
                        break;
                    }
                    case MAGIC: {
                        dragons.forEach(playerEntity -> ConfigHandler.getResourceElements(MobEffect.class, ServerConfig.magicBeaconEffects).forEach(effect -> {
                            if (effect != null) {
                                playerEntity.m_7292_(new MobEffectInstance(effect, Functions.minutesToTicks(ServerConfig.minutesOfDragonEffect) + 5, 0, true, true));
                            }
                        }));
                        break;
                    }
                    case FIRE: {
                        dragons.forEach(playerEntity -> ConfigHandler.getResourceElements(MobEffect.class, ServerConfig.fireBeaconEffects).forEach(effect -> {
                            if (effect != null) {
                                playerEntity.m_7292_(new MobEffectInstance(effect, Functions.minutesToTicks(ServerConfig.minutesOfDragonEffect) + 5, 0, true, true));
                            }
                        }));
                    }
                }
            }
        } else if (((Boolean)pState.m_61143_((Property)DragonBeacon.LIT)).booleanValue()) {
            pLevel.m_46597_(pPos, (BlockState)pState.m_61122_((Property)DragonBeacon.LIT));
            pLevel.m_5594_(null, pPos, SoundRegistry.deactivateBeacon, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void setType(DragonBeaconTileEntity beaconTileEntity, Block beacon) {
        if (beaconTileEntity.type == Type.NONE) {
            if (beacon == DSBlocks.magicDragonBeacon) {
                beaconTileEntity.type = Type.MAGIC;
            } else if (beacon == DSBlocks.peaceDragonBeacon) {
                beaconTileEntity.type = Type.PEACE;
            } else if (beacon == DSBlocks.fireDragonBeacon) {
                beaconTileEntity.type = Type.FIRE;
            }
        }
    }

    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.type = Type.valueOf(compoundNBT.m_128461_("Type"));
    }

    public void m_183515_(CompoundTag compoundNBT) {
        compoundNBT.m_128359_("Type", this.type.name());
    }

    public static enum Type {
        PEACE,
        MAGIC,
        FIRE,
        NONE;

    }
}

