/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.mixins.AccessorAnimationController;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class AnimationUtils {
    private static final float MS_FOR_60FPS = 16.666668f;
    private static final float MS_PER_TICK = 50.0f;

    public static RawAnimation createAnimation(@Nullable RawAnimation builder, @NotNull RawAnimation staticAnimation) {
        if (builder == null) {
            return staticAnimation;
        }
        assert (staticAnimation.getAnimationStages().size() == 1);
        RawAnimation.Stage stage = (RawAnimation.Stage)staticAnimation.getAnimationStages().get(0);
        builder.then(stage.animationName(), stage.loopType());
        return builder;
    }

    public static <E extends GeoAnimatable> void setAnimationSpeed(double speed, double currentAnimationTick, AnimationController<E> controller) {
        if (speed == controller.getAnimationSpeed()) {
            return;
        }
        if (controller.getCurrentAnimation() != null) {
            double distance = currentAnimationTick - ((AccessorAnimationController)controller).dragonSurvival$getTickOffset();
            ((AccessorAnimationController)controller).dragonSurvival$setTickOffset(currentAnimationTick - distance * (controller.getAnimationSpeed() / speed));
            controller.setAnimationSpeed(speed);
        }
    }

    public static boolean isAnimationPlaying(AnimationController<?> controller, RawAnimation animation) {
        String animationName = ((RawAnimation.Stage)animation.getAnimationStages().get(0)).animationName();
        return controller.getCurrentAnimation() != null && controller.getCurrentAnimation().animation().name().equals(animationName);
    }

    public static double getMovementSpeed(LivingEntity of) {
        return Math.sqrt(Math.pow(of.m_20185_() - of.f_19854_, 2.0) + Math.pow(of.m_20189_() - of.f_19856_, 2.0));
    }

    public static float getDeltaTickFor60FPS() {
        float deltaTick = Minecraft.m_91087_().m_91297_();
        return deltaTick / 0.33333337f;
    }

    public static float getRealtimeDeltaTicks() {
        return Minecraft.m_91087_().m_91297_();
    }
}

