/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateProvider;
import by.dragonsurvivalteam.dragonsurvival.common.capability.EntityStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonBody;
import by.dragonsurvivalteam.dragonsurvival.common.dragon_types.AbstractDragonType;
import by.dragonsurvivalteam.dragonsurvival.util.DragonLevel;
import com.google.common.base.Objects;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.common.util.LazyOptional;

public class DragonUtils {
    public static DragonStateHandler getHandler(Entity entity) {
        if (entity == null) {
            return new DragonStateHandler();
        }
        LazyOptional<DragonStateHandler> cap = DragonStateProvider.getCap(entity);
        return (DragonStateHandler)cap.orElse((Object)new DragonStateHandler());
    }

    public static EntityStateHandler getEntityHandler(Entity entity) {
        if (entity == null) {
            return new EntityStateHandler();
        }
        LazyOptional<? extends EntityStateHandler> cap = DragonStateProvider.getEntityCap(entity);
        return (EntityStateHandler)cap.orElse((Object)new EntityStateHandler());
    }

    public static boolean isDragon(Entity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return DragonStateProvider.getCap(entity).filter(DragonStateHandler::isDragon).isPresent();
    }

    public static AbstractDragonType getDragonType(Entity entity) {
        return DragonUtils.getHandler(entity).getType();
    }

    public static AbstractDragonType getDragonType(DragonStateHandler handler) {
        return handler.getType();
    }

    public static AbstractDragonBody getDragonBody(Entity entity) {
        return DragonUtils.getHandler(entity).getBody();
    }

    public static AbstractDragonBody getDragonBody(DragonStateHandler handler) {
        return handler.getBody();
    }

    public static boolean isDragonType(Entity entity, AbstractDragonType typeToCheck) {
        if (!(entity instanceof Player)) {
            return false;
        }
        return DragonUtils.isDragonType(DragonUtils.getHandler(entity), typeToCheck);
    }

    public static boolean isDragonType(DragonStateHandler playerHandler, AbstractDragonType typeToCheck) {
        if (playerHandler == null || typeToCheck == null || playerHandler.getType() == null) {
            return false;
        }
        return Objects.equal((Object)playerHandler.getType().getTypeName(), (Object)typeToCheck.getTypeName());
    }

    public static boolean isDragonType(AbstractDragonType playerType, AbstractDragonType typeToCheck) {
        if (playerType == null || typeToCheck == null) {
            return false;
        }
        return Objects.equal((Object)playerType.getTypeName(), (Object)typeToCheck.getTypeName());
    }

    public static DragonLevel getDragonLevel(Entity entity) {
        return DragonUtils.getHandler(entity).getLevel();
    }

    @Nullable
    public static Tier levelToVanillaTier(int level) {
        if (level < 0) {
            return null;
        }
        if (level == 0) {
            return Tiers.WOOD;
        }
        if (level == 1) {
            return Tiers.STONE;
        }
        if (level == 2) {
            return Tiers.IRON;
        }
        if (level == 3) {
            return Tiers.DIAMOND;
        }
        return Tiers.NETHERITE;
    }
}

