/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3f;

public class Functions {
    public static int minutesToTicks(int minutes) {
        return Functions.secondsToTicks(minutes) * 60;
    }

    public static int secondsToTicks(double seconds) {
        return (int)(seconds * 20.0);
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static double ticksToMinutes(int ticks) {
        return Functions.ticksToSeconds(ticks) / 60.0;
    }

    public static double ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static float angleDifference(float angle1, float angle2) {
        float phi = Math.abs(angle1 - angle2) % 360.0f;
        float dif = phi > 180.0f ? 360.0f - phi : phi;
        int sign = angle1 - angle2 >= 0.0f && angle1 - angle2 <= 180.0f || angle1 - angle2 <= -180.0f && angle1 - angle2 >= -360.0f ? 1 : -1;
        return dif *= (float)sign;
    }

    public static ListTag newDoubleList(double ... pNumbers) {
        ListTag listtag = new ListTag();
        for (double d0 : pNumbers) {
            listtag.add((Object)DoubleTag.m_128500_((double)d0));
        }
        return listtag;
    }

    public static double angleDifference(double a, double b) {
        return Mth.m_14175_((double)(b - a));
    }

    public static double limitAngleDelta(double value, double center, double halfRange) {
        if (halfRange <= 0.0) {
            return Mth.m_14175_((double)center);
        }
        if (halfRange >= 180.0) {
            return Mth.m_14175_((double)value);
        }
        double delta = Functions.angleDifference(center, value);
        delta = Mth.m_14008_((double)delta, (double)(-halfRange), (double)halfRange);
        return center + delta;
    }

    public static double lerpYaw(double delta, double start, double end) {
        double diff = (start = Mth.m_14175_((double)start)) - (end = Mth.m_14175_((double)end));
        end = diff > 180.0 || diff < -180.0 ? start + Math.copySign(360.0 - Math.abs(diff), diff) : end;
        return Mth.m_14139_((double)delta, (double)start, (double)end);
    }

    public static double limitAngleDeltaSoft(double value, double center, double halfRange, double pullCoeff) {
        pullCoeff = Mth.m_14008_((double)pullCoeff, (double)0.0, (double)1.0);
        double targetAngle = Functions.limitAngleDelta(value, center, halfRange);
        return Functions.lerpYaw(pullCoeff, value, targetAngle);
    }

    public static double lerpAngleAwayFrom(double t, double start, double end, double avoidAngle) {
        boolean flipDir;
        if (Math.abs(Mth.m_14175_((double)(avoidAngle - end))) < 1.0E-4) {
            return Functions.lerpYaw(t, start, end);
        }
        start = Mth.m_14175_((double)start);
        end = Mth.m_14175_((double)end);
        double diff = Mth.m_14175_((double)(end - start));
        double avoidDiff = Mth.m_14175_((double)(avoidAngle - start));
        boolean bl = flipDir = Math.signum(diff) == Math.signum(avoidDiff) && Math.abs(diff) > Math.abs(avoidDiff);
        if (flipDir) {
            diff = Math.copySign(360.0 - Math.abs(diff), -diff);
        }
        return Mth.m_14175_((double)(start + diff * t));
    }

    public static double inverseLerp(double value, double start, double end) {
        return (value - start) / (end - start);
    }

    public static double inverseLerpClamped(double value, double start, double end) {
        return Mth.m_14008_((double)Functions.inverseLerp(value, start, end), (double)0.0, (double)1.0);
    }

    public static double inverseLerpClampedSafe(double value, double start, double end) {
        return start - end == 0.0 ? 0.0 : Functions.inverseLerpClamped(value, start, end);
    }

    public static double deadzoneNormalized(double value, double deadzone, double maxRange) {
        return Math.copySign(Functions.inverseLerpClamped(Math.abs(value), deadzone, maxRange), value);
    }

    public static ListTag newFloatList(float ... pNumbers) {
        ListTag listtag = new ListTag();
        for (float f : pNumbers) {
            listtag.add((Object)FloatTag.m_128566_((float)f));
        }
        return listtag;
    }

    public static int wrap(int value, int min, int max) {
        return value < min ? max : (value > max ? min : value);
    }

    public static Vector3f getDragonCameraOffset(Entity entity) {
        Player player;
        DragonStateHandler handler;
        Vector3f lookVector = new Vector3f(0.0f, 0.0f, 0.0f);
        if (entity instanceof Player && (handler = DragonUtils.getHandler((Entity)(player = (Player)entity))).isDragon()) {
            float f1 = -((float)handler.getMovementData().bodyYaw) * ((float)Math.PI / 180);
            float f4 = Mth.m_14031_((float)f1);
            float f5 = Mth.m_14089_((float)f1);
            lookVector.set((float)((double)f4 * (handler.getSize() / 40.0)), 0.0f, (float)((double)f5 * (handler.getSize() / 40.0)));
        }
        return lookVector;
    }
}

