/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;

public class TargetingFunctions {
    public static boolean attackTargets(Entity attacker, Function<Entity, Boolean> action, Entity ... entities) {
        boolean valid = false;
        for (Entity entity : entities) {
            if (!TargetingFunctions.isValidTarget(attacker, entity) || !action.apply(entity).booleanValue()) continue;
            valid = true;
        }
        return valid;
    }

    public static boolean isValidTarget(Entity attacker, Entity target) {
        if (target == null || attacker == null) {
            return false;
        }
        if (target == attacker) {
            return false;
        }
        if (target instanceof FakePlayer) {
            return false;
        }
        if (attacker instanceof Player) {
            Player targetPlayer;
            Player attackerPlayer = (Player)attacker;
            if (target instanceof Player && !attackerPlayer.m_7099_(targetPlayer = (Player)target)) {
                return false;
            }
        }
        if (attacker.m_5647_() != null && target.m_5647_() != null && attacker.m_5647_().m_6809_().contains(target.m_6302_()) && !target.m_5647_().m_6260_()) {
            return false;
        }
        if (target instanceof TamableAnimal && ((TamableAnimal)target).m_269323_() == attacker) {
            return false;
        }
        return !(attacker instanceof TamableAnimal) || TargetingFunctions.isValidTarget((Entity)((TamableAnimal)attacker).m_269323_(), target);
    }

    public static AABB boxForRange(Vec3 v, double range) {
        return TargetingFunctions.boxForRange(v, range, range, range);
    }

    public static AABB boxForRange(Vec3 v, double rangeX, double rangeY, double rangeZ) {
        return new AABB(v.f_82479_ - rangeX, v.f_82480_ - rangeY, v.f_82481_ - rangeZ, v.f_82479_ + rangeX, v.f_82480_ + rangeY, v.f_82481_ + rangeZ);
    }

    public static Vec3 fromEntityCenter(Entity e) {
        return new Vec3(e.m_20185_(), e.m_20186_() + (double)(e.m_20206_() / 2.0f), e.m_20189_());
    }
}

