/*
 * Decompiled with CFR 0.152.
 */
package by.dragonsurvivalteam.dragonsurvival.util;

import by.dragonsurvivalteam.dragonsurvival.DragonSurvivalMod;
import by.dragonsurvivalteam.dragonsurvival.common.capability.DragonStateHandler;
import by.dragonsurvivalteam.dragonsurvival.common.handlers.magic.ClawToolHandler;
import by.dragonsurvivalteam.dragonsurvival.util.DragonUtils;
import com.mojang.datafixers.util.Pair;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class ToolUtils {
    public static boolean shouldUseDragonTools(ItemStack itemStack) {
        return !(itemStack.m_41720_() instanceof TieredItem) && !ToolUtils.isHarvestTool(itemStack) && !ToolUtils.isWeapon(itemStack);
    }

    public static boolean isHarvestTool(ItemStack itemStack) {
        return ToolUtils.isPickaxe(itemStack) || ToolUtils.isAxe(itemStack) || ToolUtils.isShovel(itemStack) || ToolUtils.isHoe(itemStack) || ToolUtils.isShears(itemStack);
    }

    public static boolean isWeapon(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof SwordItem || itemStack.canPerformAction(ToolActions.SWORD_DIG) || itemStack.canPerformAction(ToolActions.SWORD_SWEEP) || itemStack.m_204117_(ItemTags.f_271388_) || itemStack.canPerformAction(ToolActions.AXE_DIG);
    }

    public static boolean isPickaxe(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof PickaxeItem || itemStack.canPerformAction(ToolActions.PICKAXE_DIG) || itemStack.m_204117_(ItemTags.f_271360_) || itemStack.m_41720_().m_8096_(Blocks.f_50069_.m_49966_());
    }

    public static boolean isAxe(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof AxeItem || itemStack.canPerformAction(ToolActions.AXE_STRIP) || itemStack.canPerformAction(ToolActions.AXE_DIG) || itemStack.canPerformAction(ToolActions.AXE_SCRAPE) || itemStack.m_204117_(ItemTags.f_271207_) || itemStack.m_41720_().m_8096_(Blocks.f_49999_.m_49966_());
    }

    public static boolean isShovel(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof ShovelItem || itemStack.canPerformAction(ToolActions.SHOVEL_FLATTEN) || itemStack.canPerformAction(ToolActions.SHOVEL_DIG) || itemStack.m_204117_(ItemTags.f_271138_) || itemStack.m_41720_().m_8096_(Blocks.f_50493_.m_49966_());
    }

    public static boolean isHoe(ItemStack itemStack) {
        return itemStack.canPerformAction(ToolActions.HOE_DIG) || itemStack.canPerformAction(ToolActions.HOE_TILL) || itemStack.m_204117_(ItemTags.f_271298_);
    }

    public static boolean isShears(ItemStack itemStack) {
        return itemStack.canPerformAction(ToolActions.SHEARS_CARVE) || itemStack.canPerformAction(ToolActions.SHEARS_DIG) || itemStack.canPerformAction(ToolActions.SHEARS_DISARM) || itemStack.canPerformAction(ToolActions.SHEARS_HARVEST) || itemStack.m_204117_(Tags.Items.SHEARS);
    }

    public static void swapStart(@Nullable Player player, BlockState blockState) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.isDragon()) {
            return;
        }
        Pair<ItemStack, Integer> data = ClawToolHandler.getDragonHarvestToolAndSlot(player, blockState);
        ItemStack dragonHarvestTool = (ItemStack)data.getFirst();
        int toolSlot = (Integer)data.getSecond();
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        if (toolSlot != -1 && !handler.switchedTool) {
            player.m_21008_(InteractionHand.MAIN_HAND, dragonHarvestTool);
            handler.getClawToolData().getClawsInventory().m_6836_(toolSlot, ItemStack.f_41583_);
            handler.storedMainHandTool = mainHand;
            handler.switchedTool = true;
            handler.switchedToolSlot = toolSlot;
        }
        ++handler.toolSwapLayer;
    }

    public static void swapFinish(@Nullable Player player) {
        if (player == null || player.m_7500_() || player.m_5833_()) {
            return;
        }
        DragonStateHandler handler = DragonUtils.getHandler((Entity)player);
        if (!handler.isDragon()) {
            return;
        }
        --handler.toolSwapLayer;
        if (handler.toolSwapLayer < 0) {
            DragonSurvivalMod.LOGGER.warn("Tool swap layer was lower than 0 - this should not happen");
            handler.toolSwapLayer = 0;
        }
        if (handler.switchedTool && handler.toolSwapLayer == 0) {
            ItemStack originalMainHand = handler.storedMainHandTool;
            ItemStack originalToolSlot = player.m_21120_(InteractionHand.MAIN_HAND);
            player.m_21008_(InteractionHand.MAIN_HAND, originalMainHand);
            handler.getClawToolData().getClawsInventory().m_6836_(handler.switchedToolSlot, originalToolSlot);
            handler.storedMainHandTool = ItemStack.f_41583_;
            handler.switchedTool = false;
            handler.switchedToolSlot = -1;
        }
    }

    @Nullable
    public static Pair<Player, BlockState> getEventData(Event event) {
        Player player = null;
        BlockState blockState = null;
        if (event instanceof BlockEvent.BreakEvent) {
            BlockEvent.BreakEvent breakEvent = (BlockEvent.BreakEvent)event;
            player = breakEvent.getPlayer();
            blockState = breakEvent.getState();
        } else if (event instanceof PlayerEvent.BreakSpeed) {
            PlayerEvent.BreakSpeed breakSpeed = (PlayerEvent.BreakSpeed)event;
            player = breakSpeed.getEntity();
            blockState = breakSpeed.getState();
        } else if (event instanceof PlayerEvent.HarvestCheck) {
            PlayerEvent.HarvestCheck harvestCheck = (PlayerEvent.HarvestCheck)event;
            player = harvestCheck.getEntity();
            blockState = harvestCheck.getTargetBlock();
        }
        if (player != null) {
            return Pair.of((Object)player, (Object)blockState);
        }
        return null;
    }
}

