/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block;

import com.renyigesai.bakeries.block.TankBlock;
import com.renyigesai.bakeries.init.BakeriesBlocks;
import com.renyigesai.bakeries.init.BakeriesItems;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class MilkTankBlock
extends TankBlock {
    public static final IntegerProperty MILK = IntegerProperty.m_61631_((String)"milk", (int)0, (int)3);
    public static final BooleanProperty SALT = BooleanProperty.m_61465_((String)"salt");

    public MilkTankBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)MILK, (Comparable)Integer.valueOf(3))).m_61124_((Property)SALT, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer, @NotNull InteractionHand pHand, @NotNull BlockHitResult pHit) {
        ItemStack hand = pPlayer.m_21120_(pHand);
        if (hand.m_150930_(Items.f_42590_)) {
            return MilkTankBlock.ladleOut(pLevel, pPos, pState, pPlayer, pHand);
        }
        if (hand.m_150930_((Item)BakeriesItems.BOTTLE_MILK.get())) {
            return this.fillMilk(pLevel, pPos, pState, pPlayer, pHand);
        }
        if (hand.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("forge:salt")))) {
            return MilkTankBlock.fillSalt(pLevel, pPos, pState, pPlayer, pHand);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public static InteractionResult ladleOut(Level level, BlockPos pos, BlockState state, Player playerIn, InteractionHand pHand) {
        ItemStack hand = playerIn.m_21120_(pHand);
        int milk = (Integer)state.m_61143_((Property)MILK);
        if (milk > 1) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MILK, (Comparable)Integer.valueOf(milk - 1)), 3);
        } else {
            level.m_7731_(pos, ((Block)BakeriesBlocks.FERMENTATION_TANK.get()).m_49966_(), 0);
        }
        hand.m_41774_(1);
        ItemUtil.givePlayerItem(playerIn, new ItemStack((ItemLike)BakeriesItems.BOTTLE_MILK.get()));
        level.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }

    public InteractionResult fillMilk(Level level, BlockPos pos, BlockState state, Player playerIn, InteractionHand pHand) {
        ItemStack hand = playerIn.m_21120_(pHand);
        int milk = (Integer)state.m_61143_((Property)MILK);
        if (milk < 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)MILK, (Comparable)Integer.valueOf(milk + 1)), 3);
            hand.m_41774_(1);
            ItemUtil.givePlayerItem(playerIn, new ItemStack((ItemLike)BakeriesItems.BOTTLE_MILK.get()));
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult fillSalt(Level level, BlockPos pos, BlockState state, Player playerIn, InteractionHand pHand) {
        ItemStack handStack = playerIn.m_21120_(pHand);
        int milk = (Integer)state.m_61143_((Property)MILK);
        if (milk == 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SALT, (Comparable)Boolean.valueOf(true)), 0);
            handStack.m_41774_(1);
            level.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.PLAYERS, 0.8f, 0.8f);
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{MILK, SALT});
    }

    public void m_213898_(BlockState pState, @NotNull ServerLevel pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        int milk = (Integer)pState.m_61143_((Property)MILK);
        boolean sweet_berries = (Boolean)pState.m_61143_((Property)SALT);
        if (milk == 3 && sweet_berries) {
            pLevel.m_7731_(pPos, ((Block)BakeriesBlocks.CHEESE_TANK.get()).m_49966_(), 3);
        }
    }

    public void m_214162_(BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull RandomSource pRandom) {
        double d2;
        int milk = (Integer)pState.m_61143_((Property)MILK);
        boolean sweet_berries = (Boolean)pState.m_61143_((Property)SALT);
        Direction direction = Direction.m_235672_((RandomSource)pRandom);
        double d0 = direction.m_122429_() == 0 ? pRandom.m_188500_() : 0.5 + (double)direction.m_122429_() * 0.6;
        double d1 = direction.m_122430_() == 0 ? pRandom.m_188500_() : 0.5 + (double)direction.m_122430_() * 0.6;
        double d = d2 = direction.m_122431_() == 0 ? pRandom.m_188500_() : 0.5 + (double)direction.m_122431_() * 0.6;
        if (milk == 3 && sweet_berries) {
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)pPos.m_123341_() + d0, (double)pPos.m_123342_() + d1, (double)pPos.m_123343_() + d2, 0.0, 0.0, 0.0);
        }
    }
}

