/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.mix_block;

import com.renyigesai.bakeries.api.block.PileBlock;
import com.renyigesai.bakeries.block.mix_block.MixBlockEntity;
import com.renyigesai.bakeries.util.ItemUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public MixBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(0.5f, 0.5f).m_60918_(SoundType.f_56745_).m_60955_().m_60924_((bs, br, bp) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        return true;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_());
    }

    @NotNull
    public BlockState m_7417_(@NotNull BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        return facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7898_(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_7495_()).m_280296_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!pPlayer.m_6144_()) {
            return this.take(pLevel, pPos, pPlayer);
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public InteractionResult take(Level pLevel, BlockPos pPos, Player pPlayer) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof MixBlockEntity)) {
            return InteractionResult.FAIL;
        }
        MixBlockEntity mix = (MixBlockEntity)blockEntity;
        ItemStackHandler inventory = mix.getInventory();
        boolean flag = false;
        ItemStack outStack = ItemStack.f_41583_;
        int inventoryCount = mix.getInventoryCount();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stackInSlot = inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            System.out.println(stackInSlot);
            outStack = stackInSlot.m_41777_();
            System.out.println(outStack);
            inventory.setStackInSlot(i, ItemStack.f_41583_);
            mix.updateBlock();
            flag = true;
            break;
        }
        if (flag) {
            SoundEvent soundEvent;
            BlockItem blockItem;
            Item item;
            if (inventoryCount == 1) {
                pLevel.m_7471_(pPos, false);
            }
            if ((item = outStack.m_41720_()) instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof PileBlock) {
                PileBlock pileBlock = (PileBlock)item;
                soundEvent = pileBlock.getTakeSound();
            } else {
                soundEvent = SoundEvents.f_12639_;
            }
            ItemUtil.givePlayerItem(pPlayer, outStack);
            pLevel.m_247517_(null, pPos, soundEvent, SoundSource.BLOCKS);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof MixBlockEntity) {
                MixBlockEntity mix = (MixBlockEntity)blockEntity;
                mix.drops(mix);
                world.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof MixBlockEntity) {
            MixBlockEntity mix = (MixBlockEntity)blockEntity;
            return new ItemStack((ItemLike)mix.getInventory().getStackInSlot(0).m_41720_());
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new MixBlockEntity(pPos, pState);
    }
}

