/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.mix_block;

import com.renyigesai.bakeries.init.BakeriesBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class MixBlockEntity
extends BlockEntity {
    private final ItemStackHandler inventory = new ItemStackHandler(4){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return super.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return super.extractItem(slot, amount, simulate);
        }
    };

    public MixBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BakeriesBlocks.MIX_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public int getInventoryCount() {
        int count = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public void drops(MixBlockEntity blockEntity) {
        SimpleContainer inventory = new SimpleContainer(blockEntity.inventory.getSlots() + 1);
        for (int i = 0; i < blockEntity.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = blockEntity.inventory.getStackInSlot(i);
            if (stackInSlot.hasCraftingRemainingItem()) continue;
            inventory.m_6836_(i, blockEntity.inventory.getStackInSlot(i));
        }
        if (this.f_58857_ != null) {
            Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            this.inventory.deserializeNBT(tag.m_128469_("Inventory"));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public boolean addItem(ItemStack stack) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) continue;
            this.inventory.setStackInSlot(i, stack);
            this.updateBlock();
            return true;
        }
        return false;
    }

    public void updateBlock() {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        MixBlockEntity.m_155232_((Level)this.f_58857_, (BlockPos)this.f_58858_, (BlockState)state);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
    }
}

