/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.block.mix_block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.renyigesai.bakeries.block.mix_block.MixBlockEntity;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MixBlockEntityRender
implements BlockEntityRenderer<MixBlockEntity> {
    public static final float ADD_SIZE = 0.25f;
    public static final Vec2[][] VEC2S = new Vec2[][]{new Vec2[0], {new Vec2(0.5f, 0.5f)}, {new Vec2(0.25f, 0.5f), new Vec2(0.75f, 0.5f)}, {new Vec2(0.25f, 0.25f), new Vec2(0.75f, 0.25f), new Vec2(0.5f, 0.75f)}, {new Vec2(0.25f, 0.25f), new Vec2(0.75f, 0.25f), new Vec2(0.25f, 0.75f), new Vec2(0.75f, 0.75f)}};

    public MixBlockEntityRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(MixBlockEntity entity, float pPartialTick, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemStack stack;
        int i;
        if (entity.isEmpty()) {
            return;
        }
        Direction direction = ((Direction)entity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        int count = entity.getInventoryCount();
        if (count <= 0 || count >= VEC2S.length) {
            return;
        }
        Vec2[] positions = VEC2S[count];
        ArrayList<ItemStack> itemsToRender = new ArrayList<ItemStack>();
        for (i = 0; i < entity.getInventory().getSlots(); ++i) {
            stack = entity.getInventory().getStackInSlot(i);
            if (stack.m_41619_()) continue;
            itemsToRender.add(stack);
        }
        for (i = 0; i < itemsToRender.size() && i < positions.length; ++i) {
            stack = (ItemStack)itemsToRender.get(i);
            Vec2 position = positions[i];
            this.renderItem(stack, entity, direction, position, poseStack, pBuffer, pPackedLight, pPackedOverlay);
        }
    }

    private void renderItem(ItemStack stack, MixBlockEntity entity, Direction direction, Vec2 position, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        boolean isBlock = stack.m_41720_() instanceof BlockItem;
        int posLong = (int)entity.m_58899_().m_121878_();
        float rotation = -direction.m_122435_();
        poseStack.m_85836_();
        Vec2 transformedPosition = this.transformPositionByDirection(position, direction);
        poseStack.m_85837_((double)transformedPosition.f_82470_, 0.125, (double)transformedPosition.f_82471_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation - 15.0f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(0.0f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        if (entity.m_58904_() != null) {
            if (isBlock) {
                BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(state);
                Minecraft.m_91087_().m_91291_().m_115143_(stack, ItemDisplayContext.FIXED, false, poseStack, pBuffer, LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_()), pPackedOverlay, model);
            } else {
                Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_()), pPackedOverlay, poseStack, pBuffer, entity.m_58904_(), posLong + 1);
            }
        }
        poseStack.m_85849_();
    }

    private Vec2 transformPositionByDirection(Vec2 position, Direction direction) {
        float x = position.f_82470_;
        float y = position.f_82471_;
        return switch (direction) {
            case Direction.NORTH -> new Vec2(x, y);
            case Direction.SOUTH -> new Vec2(1.0f - x, 1.0f - y);
            case Direction.EAST -> new Vec2(y, 1.0f - x);
            case Direction.WEST -> new Vec2(1.0f - y, x);
            default -> position;
        };
    }
}

